/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.metrics.MasterMetrics;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.TableInfoCopyTask;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DisabledTableSnapshotHandler
extends TakeSnapshotHandler {
    private static final Log LOG = LogFactory.getLog(DisabledTableSnapshotHandler.class);
    private final TimeoutExceptionInjector timeoutInjector;

    public DisabledTableSnapshotHandler(HBaseProtos.SnapshotDescription snapshot, MasterServices masterServices, MasterMetrics metricsMaster) {
        super(snapshot, masterServices, metricsMaster);
        this.timeoutInjector = TakeSnapshotUtils.getMasterTimerAndBindToMonitor(snapshot, this.conf, this.monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshotRegions(List<Pair<HRegionInfo, ServerName>> regionsAndLocations) throws IOException, KeeperException {
        try {
            this.timeoutInjector.start();
            HashSet<HRegionInfo> regions = new HashSet<HRegionInfo>();
            for (Pair<HRegionInfo, ServerName> p : regionsAndLocations) {
                regions.add(p.getFirst());
            }
            LOG.info((Object)("Starting to write region info and WALs for regions for offline snapshot:" + SnapshotDescriptionUtils.toString(this.snapshot)));
            for (HRegionInfo regionInfo : regions) {
                this.snapshotDisabledRegion(regionInfo);
            }
            LOG.info((Object)("Starting to copy tableinfo for offline snapshot: " + SnapshotDescriptionUtils.toString(this.snapshot)));
            TableInfoCopyTask tableInfoCopyTask = new TableInfoCopyTask(this.monitor, this.snapshot, this.fs, FSUtils.getRootDir(this.conf));
            tableInfoCopyTask.call();
            this.monitor.rethrowException();
            this.status.setStatus("Finished copying tableinfo for snapshot of table: " + this.snapshot.getTable());
        }
        catch (Exception e) {
            String reason = "Failed snapshot " + SnapshotDescriptionUtils.toString(this.snapshot) + " due to exception:" + e.getMessage();
            ForeignException ee = new ForeignException(reason, e);
            this.monitor.receive(ee);
            this.status.abort("Snapshot of table: " + this.snapshot.getTable() + " failed because " + e.getMessage());
        }
        finally {
            LOG.debug((Object)("Marking snapshot" + SnapshotDescriptionUtils.toString(this.snapshot) + " as finished."));
            this.timeoutInjector.complete();
        }
    }
}

