/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.elasticsearch.ElasticSearchElementType;
import org.vertexium.elasticsearch.ElasticSearchSingleDocumentSearchQueryBase;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.elasticsearch.score.ScoringStrategy;
import org.vertexium.query.VertexQuery;
import org.vertexium.util.IterableUtils;

public class ElasticSearchSingleDocumentSearchVertexQuery
extends ElasticSearchSingleDocumentSearchQueryBase
implements VertexQuery {
    private final Vertex sourceVertex;

    public ElasticSearchSingleDocumentSearchVertexQuery(Client client, Graph graph, Vertex sourceVertex, String queryString, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, int pageSize, Authorizations authorizations) {
        super(client, graph, queryString, scoringStrategy, indexSelectionStrategy, pageSize, authorizations);
        this.sourceVertex = sourceVertex;
    }

    @Override
    protected List<FilterBuilder> getFilters(ElasticSearchElementType elementType) {
        List<FilterBuilder> results = super.getFilters(elementType);
        if (elementType.equals((Object)ElasticSearchElementType.VERTEX)) {
            List edgeLabels = this.getParameters().getEdgeLabels();
            String[] edgeLabelsArray = edgeLabels == null || edgeLabels.size() == 0 ? null : edgeLabels.toArray(new String[edgeLabels.size()]);
            Iterable vertexIds = this.sourceVertex.getVertexIds(Direction.BOTH, edgeLabelsArray, this.getParameters().getAuthorizations());
            String[] ids = (String[])IterableUtils.toArray((Iterable)vertexIds, String.class);
            results.add((FilterBuilder)FilterBuilders.idsFilter((String[])new String[0]).ids(ids));
        } else if (elementType.equals((Object)ElasticSearchElementType.EDGE)) {
            TermFilterBuilder inVertexIdFilter = FilterBuilders.termFilter((String)"__inVertexId", (String)this.sourceVertex.getId());
            TermFilterBuilder outVertexIdFilter = FilterBuilders.termFilter((String)"__outVertexId", (String)this.sourceVertex.getId());
            results.add((FilterBuilder)FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[]{inVertexIdFilter, outVertexIdFilter}));
        }
        return results;
    }
}

