/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.vertexium.Authorizations;

public class VertexiumQueryStringQueryBuilder
extends BaseQueryBuilder {
    private final String queryString;
    private final Authorizations authorizations;

    private VertexiumQueryStringQueryBuilder(String queryString, Authorizations authorizations) {
        this.queryString = queryString;
        this.authorizations = authorizations;
    }

    public static VertexiumQueryStringQueryBuilder build(String queryString, Authorizations authorizations) {
        return new VertexiumQueryStringQueryBuilder(queryString, authorizations);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("vertexium_query_string");
        builder.field("query", this.queryString);
        builder.startArray("authorizations");
        for (String authorization : this.authorizations.getAuthorizations()) {
            builder.value(authorization);
        }
        builder.endArray();
        builder.endObject();
    }
}

