/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.comm.channel;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.AbstractSelector;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.vesalainen.comm.channel.SerialChannel;
import org.vesalainen.comm.channel.SerialSelectionKey;
import org.vesalainen.comm.channel.SerialSelectorProvider;
import org.vesalainen.util.concurrent.ConcurrentArraySet;

public class SerialSelector
extends AbstractSelector {
    private final Set<SelectionKey> keys = new ConcurrentArraySet();
    private final Set<SelectionKey> unmodifiableKeys = Collections.unmodifiableSet(this.keys);
    private final Set<SelectionKey> selected = new ConcurrentArraySet();
    private final Set<Thread> threads = new ConcurrentArraySet();
    private boolean wakeupPending;

    SerialSelector() {
        super(SerialSelectorProvider.provider());
    }

    public static SerialSelector open() throws IOException {
        return SerialSelectorProvider.provider().openSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelector() throws IOException {
        Set<Thread> set = this.threads;
        synchronized (set) {
            if (!this.threads.isEmpty()) {
                this.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        Set<SelectionKey> set = this.keys;
        synchronized (set) {
            if (ch.isBlocking()) {
                throw new IllegalArgumentException("blocking not allowed");
            }
            if ((ops & ~ch.validOps()) != 0) {
                throw new IllegalArgumentException("ops is not supported");
            }
            SerialSelectionKey sk = new SerialSelectionKey(ch, this, ops, att);
            this.keys.add(sk);
            return sk;
        }
    }

    @Override
    public Set<SelectionKey> keys() {
        return this.unmodifiableKeys;
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.selected;
    }

    @Override
    public int selectNow() throws IOException {
        return this.select(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int select(long timeout) throws IOException {
        if (this.wakeupPending) {
            this.wakeupPending = false;
            return 0;
        }
        this.handleCancelled();
        if (!this.keys.isEmpty()) {
            this.begin();
            Thread currentThread = Thread.currentThread();
            this.threads.add(currentThread);
            try {
                int n = SerialChannel.select(this.keys, this.selected, (int)timeout);
                return n;
            }
            finally {
                this.threads.remove(currentThread);
                this.end();
                this.handleCancelled();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCancelled() {
        Set<SelectionKey> cancelledKeys;
        Set<SelectionKey> set = cancelledKeys = this.cancelledKeys();
        synchronized (set) {
            Iterator<SelectionKey> iterator = cancelledKeys.iterator();
            while (iterator.hasNext()) {
                SelectionKey sk = iterator.next();
                this.deregister((AbstractSelectionKey)sk);
                this.keys.remove(sk);
                iterator.remove();
            }
        }
    }

    @Override
    public int select() throws IOException {
        return this.select(-1L);
    }

    @Override
    public Selector wakeup() {
        if (!this.threads.isEmpty()) {
            SerialChannel.wakeupSelect(this.keys);
        } else {
            this.wakeupPending = true;
        }
        return this;
    }

    public String toString() {
        return "SerialSelector{keys=" + this.keys.size() + '}';
    }
}

