/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.comm.channel.winx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.List;
import java.util.Set;
import org.vesalainen.comm.channel.SerialChannel;
import org.vesalainen.comm.channel.SerialSelectionKey;
import org.vesalainen.loader.LibraryLoader;

public class WinSerialChannel
extends SerialChannel {
    public static final int VERSION = 7;
    public static final int MAXDWORD = -1;
    public static final int EV_RXCHAR = 1;
    public static final int MaxSelect = 64;
    private static LongBuffer reads = ByteBuffer.allocateDirect(512).order(ByteOrder.nativeOrder()).asLongBuffer();
    private int readIntervalTimeout = -1;
    private int readTotalTimeoutMultiplier = -1;
    private int readTotalTimeoutConstant = 100;
    private int writeTotalTimeoutMultiplier;
    private int writeTotalTimeoutConstant;
    private static final byte[] errorReplacement;

    public WinSerialChannel(String port) {
        this.port = port;
    }

    @Override
    protected native void doClearBuffers(long var1);

    private static native void staticInit();

    @Override
    protected native void doConfigure(long var1, int var3, int var4, int var5, int var6, int var7, boolean var8) throws IOException;

    @Override
    protected native int version();

    @Override
    protected native long doOpen(byte[] var1);

    @Override
    protected native int doRead(long var1, ByteBuffer var3) throws IOException;

    @Override
    protected native int doWrite(long var1, ByteBuffer var3) throws IOException;

    public static native void setDebug(boolean var0);

    public static native void doEnumPorts(List<String> var0);

    @Override
    protected native void doClose(long var1) throws IOException;

    protected void checkVersion() {
        int version = this.version();
        if (version != 7) {
            throw new UnsatisfiedLinkError("Loaded DLL version was " + version + " needed version " + 7);
        }
    }

    @Override
    protected void setTimeouts() throws IOException {
        this.timeouts(this.address, this.readIntervalTimeout, this.readTotalTimeoutMultiplier, this.readTotalTimeoutConstant, this.writeTotalTimeoutMultiplier, this.writeTotalTimeoutConstant);
    }

    private native void timeouts(long var1, int var3, int var4, int var5, int var6, int var7) throws IOException;

    @Override
    public int validOps() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doSelect(Set<SelectionKey> keys, Set<SelectionKey> selected, int timeout) throws IOException {
        int updated = 0;
        int readIndex = 0;
        Set<SelectionKey> set = keys;
        synchronized (set) {
            for (SelectionKey sk : keys) {
                WinSerialChannel channel = (WinSerialChannel)sk.channel();
                int interestOps = sk.interestOps();
                if ((interestOps & 1) == 0) continue;
                reads.put(readIndex++, channel.address);
            }
        }
        int rc = WinSerialChannel.doSelect(readIndex, reads, timeout);
        if (rc != 0) {
            readIndex = 0;
            Set<SelectionKey> set2 = keys;
            synchronized (set2) {
                for (SelectionKey sk : keys) {
                    int readyOps = 0;
                    if (reads.get(readIndex++) == 0L) {
                        readyOps |= 1;
                    }
                    if (readyOps == 0) continue;
                    SerialSelectionKey ssk = (SerialSelectionKey)sk;
                    if (selected.contains(sk)) {
                        if (ssk.readyOps() == readyOps) continue;
                        ++updated;
                        ssk.readyOps(readyOps);
                        continue;
                    }
                    ++updated;
                    ssk.readyOps(readyOps);
                    selected.add(ssk);
                }
            }
        }
        return updated;
    }

    private native void setEventMask(long var1, int var3) throws IOException;

    private native int waitEvent(long var1, int var3) throws IOException;

    private static native int doSelect(int var0, LongBuffer var1, int var2) throws IOException;

    public static byte[] errorReplacement() {
        return errorReplacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.address != -1L) {
            int n;
            int count = 0;
            try {
                this.begin();
                count = this.doRead(this.address, dst);
                while (this.block && count == 0) {
                    this.waitEvent(1);
                    count = this.doRead(this.address, dst);
                }
                n = count;
                this.end(count > 0);
            }
            catch (Throwable throwable) {
                this.end(count > 0);
                throw throwable;
            }
            return n;
        }
        throw new ClosedChannelException();
    }

    public String toString() {
        return "WinSerialChannel{" + this.port + '}';
    }

    protected void setEventMask(int mask) throws IOException {
        this.setEventMask(this.address, mask);
    }

    protected int waitEvent(int mask) throws IOException {
        return this.waitEvent(this.address, mask);
    }

    public int getReadIntervalTimeout() {
        return this.readIntervalTimeout;
    }

    public WinSerialChannel setReadIntervalTimeout(int readIntervalTimeout) {
        this.readIntervalTimeout = readIntervalTimeout;
        return this;
    }

    public int getReadTotalTimeoutMultiplier() {
        return this.readTotalTimeoutMultiplier;
    }

    public WinSerialChannel setReadTotalTimeoutMultiplier(int readTotalTimeoutMultiplier) {
        this.readTotalTimeoutMultiplier = readTotalTimeoutMultiplier;
        return this;
    }

    public int getReadTotalTimeoutConstant() {
        return this.readTotalTimeoutConstant;
    }

    public WinSerialChannel setReadTotalTimeoutConstant(int readTotalTimeoutConstant) {
        this.readTotalTimeoutConstant = readTotalTimeoutConstant;
        return this;
    }

    public int getWriteTotalTimeoutMultiplier() {
        return this.writeTotalTimeoutMultiplier;
    }

    public WinSerialChannel setWriteTotalTimeoutMultiplier(int writeTotalTimeoutMultiplier) {
        this.writeTotalTimeoutMultiplier = writeTotalTimeoutMultiplier;
        return this;
    }

    public int getWriteTotalTimeoutConstant() {
        return this.writeTotalTimeoutConstant;
    }

    public WinSerialChannel setWriteTotalTimeoutConstant(int writeTotalTimeoutConstant) {
        this.writeTotalTimeoutConstant = writeTotalTimeoutConstant;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wakeupSelect(Set<SelectionKey> keys) {
        try {
            Set<SelectionKey> set = keys;
            synchronized (set) {
                for (SelectionKey sk : keys) {
                    WinSerialChannel channel = (WinSerialChannel)sk.channel();
                    channel.setEventMask(0);
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static {
        try {
            LibraryLoader.loadLibrary(WinSerialChannel.class, "SerialChannel");
        }
        catch (IOException | UnsatisfiedLinkError ex) {
            throw new UnsatisfiedLinkError("Can't load either 32 or 64 .dll \n" + ex.getMessage());
        }
        WinSerialChannel.staticInit();
        errorReplacement = new byte[]{-1, -1};
    }
}

