/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.loader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class LibraryLoader {
    private static final Map<String, Path> map = new HashMap<String, Path>();
    private static OS os;

    public static OS getOS() {
        if (os == null) {
            String osName = System.getProperty("os.name");
            if (osName.contains("inux")) {
                os = OS.Linux;
            } else if (osName.contains("indows")) {
                os = OS.Windows;
            } else {
                throw new UnsupportedOperationException(osName + " not supported");
            }
        }
        return os;
    }

    public static void loadLibrary(Class<?> clazz, String lib) throws IOException {
        String osArch = System.getProperty("os.arch");
        block5 : switch (LibraryLoader.getOS()) {
            case Linux: {
                switch (osArch) {
                    case "amd64": {
                        lib = lib + "x86_64";
                        break block5;
                    }
                    case "x86": {
                        lib = lib + "i686";
                        break block5;
                    }
                    case "arm": {
                        lib = lib + "armv6l";
                        break block5;
                    }
                }
                throw new UnsupportedOperationException(osArch + " not supported");
            }
            case Windows: {
                switch (osArch) {
                    case "amd64": {
                        lib = lib + "64";
                        break block5;
                    }
                    case "x86": {
                        lib = lib + "32";
                        break block5;
                    }
                }
                throw new UnsupportedOperationException(osArch + " not supported");
            }
        }
        try {
            System.loadLibrary(lib);
        }
        catch (UnsatisfiedLinkError ule) {
            if (map.containsKey(lib)) {
                return;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            String libraryName = System.mapLibraryName(lib);
            try (InputStream is = classLoader.getResourceAsStream(libraryName);){
                if (is == null) {
                    throw new UnsatisfiedLinkError(libraryName + " not found");
                }
                Path tempPath = Files.createTempFile(null, libraryName, new FileAttribute[0]);
                Files.copy(is, tempPath, StandardCopyOption.REPLACE_EXISTING);
                String path = tempPath.toString();
                System.load(path);
                System.err.println("Warning! Loading " + libraryName + " from " + path);
                System.err.println("Copy " + path + " to java.library.path as " + libraryName);
                map.put(lib, tempPath);
            }
        }
    }

    public static enum OS {
        Windows,
        Linux;

    }
}

