/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.comm.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.vesalainen.comm.channel.LinuxSerialChannel;
import org.vesalainen.comm.channel.SerialInputStream;
import org.vesalainen.comm.channel.SerialOutputStream;
import org.vesalainen.comm.channel.SerialSelectorProvider;
import org.vesalainen.comm.channel.WinSerialChannel;
import org.vesalainen.loader.LibraryLoader;
import org.vesalainen.util.logging.JavaLogging;

public abstract class SerialChannel
extends AbstractSelectableChannel
implements GatheringByteChannel,
ScatteringByteChannel {
    public static final int MaxSelectors = 64;
    protected long address = -1L;
    protected String port;
    protected Configuration configuration;
    protected boolean block = true;
    protected boolean clearOnClose;
    protected ReentrantLock readLock = new ReentrantLock();
    protected ReentrantLock writeLock = new ReentrantLock();
    protected static final JavaLogging log = new JavaLogging("org.vesalainen.comm.channel");

    protected SerialChannel() {
        super(SerialSelectorProvider.provider());
    }

    protected abstract int version();

    public void clearBuffers() {
        this.doClearBuffers(this.address);
    }

    protected abstract void doClearBuffers(long var1);

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isClearOnClose() {
        return this.clearOnClose;
    }

    public void setClearOnClose(boolean clearOnClose) {
        this.clearOnClose = clearOnClose;
    }

    static int select(Set<SelectionKey> keys, Set<SelectionKey> selected, int timeout) throws IOException {
        LibraryLoader.OS os = LibraryLoader.getOS();
        switch (os) {
            case Windows: {
                return WinSerialChannel.doSelect(keys, selected, timeout);
            }
            case Linux: {
                return LinuxSerialChannel.doSelect(keys, selected, timeout);
            }
        }
        throw new UnsupportedOperationException(os + " not supported");
    }

    static void wakeupSelect(Set<SelectionKey> keys) {
        LibraryLoader.OS os = LibraryLoader.getOS();
        switch (os) {
            case Windows: {
                WinSerialChannel.wakeupSelect(keys);
                break;
            }
            case Linux: {
                LinuxSerialChannel.wakeupSelect(keys);
                break;
            }
            default: {
                throw new UnsupportedOperationException(os + " not supported");
            }
        }
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.block = block;
        this.setTimeouts();
    }

    protected abstract void setTimeouts() throws IOException;

    public static int getSpeed(Speed speed) {
        return Integer.parseInt(speed.name().substring(1));
    }

    public static Speed getSpeed(int speed) {
        return Speed.valueOf("B" + speed);
    }

    public static DataBits getDataBits(int bits) {
        return DataBits.valueOf("DATABITS_" + bits);
    }

    public static StopBits getStopBits(int bits) {
        return StopBits.valueOf("STOPBITS_" + bits);
    }

    public static Parity getParity(String parity) {
        return Parity.valueOf(parity);
    }

    public static FlowControl getFlowControl(String flow) {
        return FlowControl.valueOf(flow);
    }

    public String getPort() {
        return this.port;
    }

    protected void open() throws IOException {
        this.address = this.doOpen(this.port.getBytes());
    }

    protected abstract long doOpen(byte[] var1);

    public static byte[] getErrorReplacement() {
        LibraryLoader.OS os = LibraryLoader.getOS();
        switch (os) {
            case Windows: {
                return WinSerialChannel.errorReplacement();
            }
            case Linux: {
                return LinuxSerialChannel.errorReplacement();
            }
        }
        throw new UnsupportedOperationException(os + " not supported");
    }

    public void configure(Configuration config) throws IOException {
        this.configuration = config;
        this.doConfigure(this.address, SerialChannel.getSpeed(this.configuration.speed), this.configuration.parity.ordinal(), this.configuration.dataBits.ordinal(), this.configuration.stopBits.ordinal(), this.configuration.flowControl.ordinal(), this.configuration.replaceError);
    }

    protected abstract void doConfigure(long var1, int var3, int var4, int var5, int var6, int var7, boolean var8) throws IOException;

    public InputStream getInputStream(int bufferSize) {
        if (!this.block) {
            throw new IllegalStateException("not allowed in non-blocking mode");
        }
        return new SerialInputStream(this, bufferSize);
    }

    public OutputStream getOutputStream(int bufferSize) {
        if (!this.block) {
            throw new IllegalStateException("not allowed in non-blocking mode");
        }
        return new SerialOutputStream(this, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.address != -1L) {
            int n;
            int count = 0;
            this.readLock.lock();
            try {
                this.begin();
                n = count = this.doRead(this.address, dst);
                this.readLock.unlock();
                this.end(count > 0);
            }
            catch (Throwable throwable) {
                this.readLock.unlock();
                this.end(count > 0);
                throw throwable;
            }
            return n;
        }
        throw new ClosedChannelException();
    }

    protected abstract int doRead(long var1, ByteBuffer var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.address != -1L) {
            int n;
            int count = 0;
            this.writeLock.lock();
            try {
                this.begin();
                n = count = this.doWrite(this.address, src);
                this.writeLock.unlock();
                this.end(count > 0);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                this.end(count > 0);
                throw throwable;
            }
            return n;
        }
        throw new ClosedChannelException();
    }

    protected abstract int doWrite(long var1, ByteBuffer var3) throws IOException;

    public static void debug(boolean on) {
        LibraryLoader.OS os = LibraryLoader.getOS();
        switch (os) {
            case Windows: {
                WinSerialChannel.setDebug(on);
                break;
            }
            case Linux: {
                LinuxSerialChannel.setDebug(on);
                break;
            }
            default: {
                throw new UnsupportedOperationException(os + " not supported");
            }
        }
    }

    public static List<String> getFreePorts() {
        Builder builder = new Builder("", Speed.B57600);
        List<String> allPorts = SerialChannel.getAllPorts();
        Iterator<String> iterator = allPorts.iterator();
        while (iterator.hasNext()) {
            String port = iterator.next();
            builder.setPort(port);
            try {
                SerialChannel sc = builder.get();
                Throwable throwable = null;
                if (sc == null) continue;
                if (throwable != null) {
                    try {
                        sc.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                sc.close();
            }
            catch (IOException ex) {
                iterator.remove();
            }
        }
        return allPorts;
    }

    public static List<String> getAllPorts() {
        ArrayList<String> list = new ArrayList<String>();
        LibraryLoader.OS os = LibraryLoader.getOS();
        switch (os) {
            case Windows: {
                WinSerialChannel.doEnumPorts(list);
                break;
            }
            case Linux: {
                LinuxSerialChannel.doEnumPorts(list);
                break;
            }
            default: {
                throw new UnsupportedOperationException(os + " not supported");
            }
        }
        return list;
    }

    public DataBits getDataBits() {
        return this.configuration.dataBits;
    }

    public FlowControl getFlowControl() {
        return this.configuration.flowControl;
    }

    public Parity getParity() {
        return this.configuration.parity;
    }

    public Speed getSpeed() {
        return this.configuration.speed;
    }

    public StopBits getStopBits() {
        return this.configuration.stopBits;
    }

    public boolean isReplaceError() {
        return this.configuration.replaceError;
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        if (this.clearOnClose) {
            this.clearBuffers();
        }
        this.doClose();
    }

    protected void doClose() throws IOException {
        this.doClose(this.address);
        this.address = -1L;
    }

    protected abstract void doClose(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.writeLock.lock();
        try {
            long res = 0L;
            for (int ii = 0; ii < length; ++ii) {
                ByteBuffer bb = srcs[ii + offset];
                if (!bb.hasRemaining()) continue;
                res += (long)this.write(bb);
                if (bb.hasRemaining()) break;
            }
            long l = res;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.readLock.lock();
        try {
            long res = 0L;
            for (int ii = 0; ii < length; ++ii) {
                ByteBuffer bb = dsts[ii + offset];
                if (!bb.hasRemaining()) continue;
                int rc = this.read(bb);
                if (rc == -1) {
                    if (res == 0L) {
                        long l = -1L;
                        return l;
                    }
                    long l = res;
                    return l;
                }
                res += (long)rc;
                if (bb.hasRemaining()) break;
            }
            long l = res;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    public static class Builder {
        private String port;
        private boolean block = true;
        private Configuration configuration;

        public Builder(String port, int speed) {
            this(port, Speed.valueOf("B" + speed));
        }

        public Builder(String port, Speed speed) {
            this.port = port;
            this.configuration = new Configuration();
            this.configuration.setSpeed(speed);
        }

        public Builder(String port, Configuration configuration) {
            this.port = port;
            this.configuration = configuration;
        }

        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public SerialChannel get() throws IOException {
            SerialChannel channel;
            switch (LibraryLoader.getOS()) {
                case Windows: {
                    channel = new WinSerialChannel(this.port);
                    break;
                }
                case Linux: {
                    channel = new LinuxSerialChannel(this.port);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OS not supported");
                }
            }
            channel.open();
            channel.configure(this.configuration);
            channel.configureBlocking(this.block);
            return channel;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public Builder setBlocking(boolean block) {
            this.block = block;
            return this;
        }

        public String getPort() {
            return this.port;
        }

        public Speed getSpeed() {
            return this.configuration.speed;
        }

        public boolean isBlock() {
            return this.block;
        }

        public Builder setStopBits(StopBits stopBits) {
            this.configuration.setStopBits(stopBits);
            return this;
        }

        public Builder setSpeed(Speed speed) {
            this.configuration.setSpeed(speed);
            return this;
        }

        public Builder setParity(Parity parity) {
            this.configuration.setParity(parity);
            return this;
        }

        public Builder setFlowControl(FlowControl flowControl) {
            this.configuration.setFlowControl(flowControl);
            return this;
        }

        public Builder setDataBits(DataBits dataBits) {
            this.configuration.setDataBits(dataBits);
            return this;
        }

        public Builder setReplaceError(boolean replace) {
            this.configuration.setReplaceError(replace);
            return this;
        }

        public int getBytesPerSecond() {
            return this.configuration.getBytesPerSecond();
        }
    }

    public static class Configuration {
        protected Speed speed;
        protected Parity parity = Parity.NONE;
        protected StopBits stopBits = StopBits.STOPBITS_1;
        protected DataBits dataBits = DataBits.DATABITS_8;
        protected FlowControl flowControl = FlowControl.NONE;
        protected boolean replaceError;

        public float getFrameSize() {
            float size = 1.0f;
            switch (this.parity) {
                case NONE: {
                    break;
                }
                default: {
                    size += 1.0f;
                }
            }
            switch (this.dataBits) {
                case DATABITS_4: {
                    size += 4.0f;
                    break;
                }
                case DATABITS_5: {
                    size += 5.0f;
                    break;
                }
                case DATABITS_6: {
                    size += 6.0f;
                    break;
                }
                case DATABITS_7: {
                    size += 7.0f;
                    break;
                }
                case DATABITS_8: {
                    size += 8.0f;
                }
            }
            switch (this.stopBits) {
                case STOPBITS_1: {
                    size += 1.0f;
                    break;
                }
                case STOPBITS_1_5: {
                    size = (float)((double)size + 1.5);
                    break;
                }
                case STOPBITS_2: {
                    size += 2.0f;
                }
            }
            return size;
        }

        public int getBytesPerSecond() {
            return (int)((float)SerialChannel.getSpeed(this.speed) / this.getFrameSize());
        }

        public Configuration setDataBits(DataBits dataBits) {
            this.dataBits = dataBits;
            return this;
        }

        public Configuration setFlowControl(FlowControl flowControl) {
            this.flowControl = flowControl;
            return this;
        }

        public Configuration setParity(Parity parity) {
            this.parity = parity;
            return this;
        }

        public Configuration setSpeed(Speed speed) {
            this.speed = speed;
            return this;
        }

        public Configuration setStopBits(StopBits stopBits) {
            this.stopBits = stopBits;
            return this;
        }

        public Configuration setReplaceError(boolean replace) {
            this.replaceError = replace;
            return this;
        }

        public Speed getSpeed() {
            return this.speed;
        }

        public Parity getParity() {
            return this.parity;
        }

        public StopBits getStopBits() {
            return this.stopBits;
        }

        public DataBits getDataBits() {
            return this.dataBits;
        }

        public FlowControl getFlowControl() {
            return this.flowControl;
        }

        public boolean isReplaceError() {
            return this.replaceError;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("baud=" + SerialChannel.getSpeed(this.speed));
            switch (this.parity) {
                case NONE: {
                    sb.append(" parity=N");
                    break;
                }
                case EVEN: {
                    sb.append(" parity=E");
                    break;
                }
                case ODD: {
                    sb.append(" parity=O");
                    break;
                }
                case MARK: {
                    sb.append(" parity=M");
                    break;
                }
                case SPACE: {
                    sb.append(" parity=S");
                }
            }
            switch (this.dataBits) {
                case DATABITS_4: {
                    sb.append(" data=4");
                    break;
                }
                case DATABITS_5: {
                    sb.append(" data=5");
                    break;
                }
                case DATABITS_6: {
                    sb.append(" data=6");
                    break;
                }
                case DATABITS_7: {
                    sb.append(" data=7");
                    break;
                }
                case DATABITS_8: {
                    sb.append(" data=8");
                }
            }
            switch (this.stopBits) {
                case STOPBITS_1: {
                    sb.append(" stop=1");
                    break;
                }
                case STOPBITS_1_5: {
                    sb.append(" stop=1.5");
                    break;
                }
                case STOPBITS_2: {
                    sb.append(" stop=2");
                }
            }
            switch (this.flowControl) {
                case NONE: {
                    break;
                }
                case XONXOFF: {
                    sb.append(" flow=2");
                    break;
                }
                case RTSCTS: {
                    sb.append(" flow=RTS/CTS");
                    break;
                }
                case DSRDTR: {
                    sb.append(" flo=DSR/DTR");
                }
            }
            return sb.toString();
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + Objects.hashCode((Object)this.speed);
            hash = 89 * hash + Objects.hashCode((Object)this.parity);
            hash = 89 * hash + Objects.hashCode((Object)this.stopBits);
            hash = 89 * hash + Objects.hashCode((Object)this.dataBits);
            hash = 89 * hash + Objects.hashCode((Object)this.flowControl);
            hash = 89 * hash + (this.replaceError ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Configuration other = (Configuration)obj;
            if (this.speed != other.speed) {
                return false;
            }
            if (this.parity != other.parity) {
                return false;
            }
            if (this.stopBits != other.stopBits) {
                return false;
            }
            if (this.dataBits != other.dataBits) {
                return false;
            }
            if (this.flowControl != other.flowControl) {
                return false;
            }
            return this.replaceError == other.replaceError;
        }
    }

    public static enum FlowControl {
        NONE,
        XONXOFF,
        RTSCTS,
        DSRDTR;

    }

    public static enum StopBits {
        STOPBITS_1,
        STOPBITS_1_5,
        STOPBITS_2;

    }

    public static enum DataBits {
        DATABITS_4,
        DATABITS_5,
        DATABITS_6,
        DATABITS_7,
        DATABITS_8;

    }

    public static enum Parity {
        NONE,
        ODD,
        EVEN,
        MARK,
        SPACE;

    }

    public static enum Speed {
        B50,
        B75,
        B110,
        B134,
        B150,
        B200,
        B300,
        B600,
        B1200,
        B1800,
        B2400,
        B4800,
        B9600,
        B14400,
        B19200,
        B38400,
        B57600,
        B115200,
        B128000,
        B230400,
        B256000;

    }
}

