/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.comm.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.List;
import java.util.Set;
import org.vesalainen.comm.channel.SerialChannel;
import org.vesalainen.comm.channel.SerialSelectionKey;
import org.vesalainen.loader.LibraryLoader;

public class LinuxSerialChannel
extends SerialChannel {
    public static final int VERSION = 3;
    public static final int MaxBuffers = 16;
    private static LongBuffer reads = ByteBuffer.allocateDirect(512).order(ByteOrder.nativeOrder()).asLongBuffer();
    private static LongBuffer writes = ByteBuffer.allocateDirect(512).order(ByteOrder.nativeOrder()).asLongBuffer();
    private int min = 1;
    private int time;
    static ByteBuffer[] readBuffer;
    static ByteBuffer[] writeBuffer;
    private static final byte[] errorReplacement;

    LinuxSerialChannel(String port) {
        this.port = port;
        int version = this.version();
        if (version != 3) {
            throw new UnsatisfiedLinkError("Loaded DLL version was" + version + " needed version " + 3);
        }
    }

    @Override
    protected native void doClearBuffers(long var1);

    @Override
    protected native void doConfigure(long var1, int var3, int var4, int var5, int var6, int var7, boolean var8) throws IOException;

    @Override
    protected native int version();

    @Override
    protected native long doOpen(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.address != -1L) {
            long l;
            long count = 0L;
            this.readLock.lock();
            try {
                this.begin();
                l = count = (long)this.doRead(this.address, dsts, offset, length);
                this.readLock.unlock();
                this.end(count > 0L);
            }
            catch (Throwable throwable) {
                this.readLock.unlock();
                this.end(count > 0L);
                throw throwable;
            }
            return l;
        }
        throw new ClosedChannelException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRead(long handle, ByteBuffer dst) throws IOException {
        int n;
        LinuxSerialChannel.readBuffer[0] = dst;
        int count = 0;
        this.readLock.lock();
        try {
            this.begin();
            n = count = this.doRead(this.address, readBuffer, 0, 1);
            this.readLock.unlock();
            this.end(count > 0);
        }
        catch (Throwable throwable) {
            this.readLock.unlock();
            this.end(count > 0);
            throw throwable;
        }
        return n;
    }

    protected native int doRead(long var1, ByteBuffer[] var3, int var4, int var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.address != -1L) {
            long l;
            this.writeLock.lock();
            long count = 0L;
            try {
                this.begin();
                l = count = (long)this.doWrite(this.address, srcs, offset, length);
                this.writeLock.unlock();
                this.end(count > 0L);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                this.end(count > 0L);
                throw throwable;
            }
            return l;
        }
        throw new ClosedChannelException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWrite(long handle, ByteBuffer src) throws IOException {
        this.writeLock.lock();
        try {
            LinuxSerialChannel.writeBuffer[0] = src;
            int n = this.doWrite(this.address, writeBuffer, 0, 1);
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected native int doWrite(long var1, ByteBuffer[] var3, int var4, int var5) throws IOException;

    public static native void setDebug(boolean var0);

    public static native void doEnumPorts(List<String> var0);

    @Override
    protected native void doClose(long var1) throws IOException;

    @Override
    protected native void free(long var1);

    public static byte[] errorReplacement() {
        return errorReplacement;
    }

    protected void checkVersion() {
        int version = this.version();
        if (version != 3) {
            throw new UnsatisfiedLinkError("Loaded DLL version was " + version + " needed version " + 3);
        }
    }

    private static native void staticInit();

    static int doSelect(Set<SelectionKey> keys, Set<SelectionKey> selected, int timeout) {
        int interestOps;
        int updated = 0;
        int readIndex = 0;
        int writeIndex = 0;
        for (SelectionKey sk : keys) {
            LinuxSerialChannel channel = (LinuxSerialChannel)sk.channel();
            assert (channel.address != -1L);
            interestOps = sk.interestOps();
            if ((interestOps & 1) != 0) {
                reads.put(readIndex++, channel.address);
            }
            if ((interestOps & 4) == 0) continue;
            writes.put(writeIndex++, channel.address);
        }
        log.finest("select(%d, %d, %d)", new Object[]{readIndex, writeIndex, timeout});
        int rc = LinuxSerialChannel.doSelect(readIndex, writeIndex, reads, writes, timeout);
        log.finest("rc=%d", new Object[]{rc});
        if (rc != 0) {
            readIndex = 0;
            writeIndex = 0;
            for (SelectionKey sk : keys) {
                interestOps = sk.interestOps();
                int readyOps = 0;
                if ((interestOps & 1) != 0 && reads.get(readIndex++) != 0L) {
                    readyOps |= 1;
                }
                if ((interestOps & 4) != 0 && writes.get(writeIndex++) != 0L) {
                    readyOps |= 4;
                }
                if (readyOps == 0) continue;
                SerialSelectionKey ssk = (SerialSelectionKey)sk;
                if (selected.contains(sk)) {
                    if (ssk.readyOps() == readyOps) continue;
                    ++updated;
                    ssk.readyOps(readyOps);
                    continue;
                }
                ++updated;
                ssk.readyOps(readyOps);
                selected.add(sk);
            }
        }
        return updated;
    }

    private static native int doSelect(int var0, int var1, LongBuffer var2, LongBuffer var3, int var4);

    @Override
    protected void setTimeouts() throws IOException {
        if (this.address != -1L) {
            if (this.block) {
                this.timeouts(this.address, this.min, this.time);
            } else {
                this.timeouts(this.address, 0, 10);
            }
        }
    }

    private native void timeouts(long var1, int var3, int var4) throws IOException;

    @Override
    public int validOps() {
        return 5;
    }

    static void wakeupSelect(Set<SelectionKey> keys) {
        try {
            LinuxSerialChannel.wakeupSelect();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static native void wakeupSelect() throws IOException;

    public String toString() {
        return "LinuxSerialChannel{" + this.port + ": " + this.configuration + "}";
    }

    static {
        try {
            LibraryLoader.loadLibrary(LinuxSerialChannel.class, (String)"SerialChannel");
        }
        catch (IOException | UnsatisfiedLinkError ex) {
            throw new UnsatisfiedLinkError("Can't load either x86_64 or arm6vl .so \n" + ex.getMessage());
        }
        LinuxSerialChannel.staticInit();
        readBuffer = new ByteBuffer[1];
        writeBuffer = new ByteBuffer[1];
        errorReplacement = new byte[]{-1, 0};
    }
}

