/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.grammar.math;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.vesalainen.bcc.model.El;
import org.vesalainen.grammar.math.DEH;
import org.vesalainen.grammar.math.ExpressionHandler;
import org.vesalainen.grammar.math.MathExpressionParserIntf;
import org.vesalainen.grammar.math.MethodExpressionHandler;
import org.vesalainen.parser.GenClassFactory;
import org.vesalainen.parser.annotation.GenClassname;
import org.vesalainen.parser.annotation.GrammarDef;
import org.vesalainen.parser.annotation.MathExpression;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.parser.annotation.Terminals;
import org.vesalainen.parser.util.DelayedExecutor;

@GenClassname(value="org.vesalainen.grammar.impl.MathExpressionParserImpl")
@GrammarDef
@Terminals(value={@Terminal(left="SQUARE", expression="[\u00b2\u2072]"), @Terminal(left="CUBE", expression="[\u00b3\u2073]"), @Terminal(left="PI", expression="\u03c0"), @Terminal(left="SQRT", expression="\u221a"), @Terminal(left="CBRT", expression="\u2218"), @Terminal(left="PLUS", expression="\\+"), @Terminal(left="MINUS", expression="\\-"), @Terminal(left="STAR", expression="\\*"), @Terminal(left="SLASH", expression="/"), @Terminal(left="PERCENT", expression="%"), @Terminal(left="EXP", expression="\\^"), @Terminal(left="COMMA", expression="\\,"), @Terminal(left="PIPE", expression="\\|"), @Terminal(left="EXCL", expression="!"), @Terminal(left="LBRACKET", expression="\\["), @Terminal(left="RBRACKET", expression="\\]"), @Terminal(left="LPAREN", expression="\\("), @Terminal(left="RPAREN", expression="\\)")})
public abstract class MathExpressionParser
implements MathExpressionParserIntf {
    private static final Set<ExecutableElement> degreeArgs = new HashSet<ExecutableElement>();
    private static final Set<ExecutableElement> degreeReturns = new HashSet<ExecutableElement>();

    public void parse(MathExpression me, MethodExpressionHandler handler) throws ReflectiveOperationException {
        DEH expression = this.parse(me.value(), me.degrees(), handler);
        expression.execute((Object)handler);
    }

    @ParseMethod(start="expression", size=1024, whiteSpace={"whiteSpace"})
    protected abstract DEH parse(String var1, @ParserContext(value="degrees") boolean var2, @ParserContext(value="handler") MethodExpressionHandler var3);

    @Rule(value={"term"})
    protected DEH expression(DEH term) {
        return term;
    }

    @Rule(value={"factor"})
    protected DEH term(DEH factor) {
        return factor;
    }

    @Rule(value={"atom"})
    protected DEH factor(DEH atom) {
        return atom;
    }

    @Rule(value={"LPAREN", "expression", "RPAREN"})
    protected DEH atom(DEH expression) {
        return expression;
    }

    @Rule
    protected List<DEH> expressionList() {
        return new ArrayList<DEH>();
    }

    @Rule(value={"expression"})
    protected List<DEH> expressionList(DEH expression) {
        ArrayList<DEH> list = new ArrayList<DEH>();
        list.add(expression);
        return list;
    }

    @Rule(value={"expressionList", "COMMA", "expression"})
    protected List<DEH> expressionList(List<DEH> list, DEH expression) {
        list.add(expression);
        return list;
    }

    @Rule(left="expression", value={"expression", "PLUS", "term"})
    protected DEH add(DEH expression, DEH term) throws IOException {
        expression.append((DelayedExecutor)term);
        ((ExpressionHandler)expression.getProxy()).add();
        return expression;
    }

    @Rule(left="expression", value={"expression", "MINUS", "term"})
    protected DEH subtract(DEH expression, DEH term) throws IOException {
        expression.append((DelayedExecutor)term);
        ((ExpressionHandler)expression.getProxy()).subtract();
        return expression;
    }

    @Rule(left="term", value={"term", "STAR", "factor"})
    protected DEH mul(DEH term, DEH factor) throws IOException {
        term.append((DelayedExecutor)factor);
        ((ExpressionHandler)term.getProxy()).mul();
        return term;
    }

    @Rule(left="term", value={"term", "SLASH", "factor"})
    protected DEH div(DEH term, DEH factor) throws IOException {
        term.append((DelayedExecutor)factor);
        ((ExpressionHandler)term.getProxy()).div();
        return term;
    }

    @Rule(left="term", value={"term", "PERCENT", "factor"})
    protected DEH mod(DEH term, DEH factor) throws IOException {
        term.append((DelayedExecutor)factor);
        ((ExpressionHandler)term.getProxy()).mod();
        return term;
    }

    @Rule(left="atom", value={"number"})
    protected DEH num(String number) throws IOException {
        DEH atom = new DEH();
        ((ExpressionHandler)atom.getProxy()).number(number);
        return atom;
    }

    @Rule(left="atom", value={"PIPE", "expression", "PIPE"})
    protected DEH abs(DEH expression, @ParserContext(value="degrees") boolean degrees, @ParserContext(value="handler") MethodExpressionHandler handler) throws IOException {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(expression);
        return this.func("abs", args, degrees, handler);
    }

    @Rule(left="factor", value={"atom", "EXP", "factor"})
    protected DEH power(DEH atom, DEH factor, @ParserContext(value="degrees") boolean degrees, @ParserContext(value="handler") MethodExpressionHandler handler) throws IOException {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(atom);
        args.add(factor);
        return this.func("pow", args, degrees, handler);
    }

    @Rule(left="atom", value={"atom", "EXCL"})
    protected DEH factorial(DEH atom, @ParserContext(value="degrees") boolean degrees, @ParserContext(value="handler") MethodExpressionHandler handler) throws IOException {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(atom);
        return this.func("factorial", args, degrees, handler);
    }

    @Rule(left="atom", value={"atom", "SQUARE"})
    protected DEH square(DEH atom) throws IOException {
        ((ExpressionHandler)atom.getProxy()).pow(2);
        return atom;
    }

    @Rule(left="atom", value={"atom", "CUBE"})
    protected DEH cube(DEH atom) throws IOException {
        ((ExpressionHandler)atom.getProxy()).pow(3);
        return atom;
    }

    @Rule(left="factor", value={"SQRT", "atom"})
    protected DEH sqrt(DEH atom, @ParserContext(value="handler") MethodExpressionHandler handler) throws IOException {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(atom);
        return this.func("sqrt", args, false, handler);
    }

    @Rule(left="factor", value={"CBRT", "atom"})
    protected DEH cbrt(DEH atom, @ParserContext(value="handler") MethodExpressionHandler handler) throws IOException {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(atom);
        return this.func("cbrt", args, false, handler);
    }

    @Rule(left="atom", value={"PI"})
    protected DEH pi() throws IOException {
        DEH atom = new DEH();
        ((ExpressionHandler)atom.getProxy()).loadField(El.getField(Math.class, (String)"PI"));
        return atom;
    }

    @Rule(left="neg")
    protected boolean none() {
        return false;
    }

    @Rule(left="neg", value={"MINUS"})
    protected boolean minus() {
        return true;
    }

    @Rule
    protected List<DEH> indexList() throws IOException {
        return new ArrayList<DEH>();
    }

    @Rule(value={"indexList", "LBRACKET", "expression", "RBRACKET"})
    protected List<DEH> indexList(List<DEH> list, DEH expression) throws IOException {
        list.add(expression);
        return list;
    }

    @Rule(left="atom", value={"neg", "identifier", "indexList"})
    protected DEH variable(boolean neg, String identifier, List<DEH> indexList) throws IOException {
        DEH atom = new DEH();
        ExpressionHandler proxy = (ExpressionHandler)atom.getProxy();
        proxy.loadVariable(identifier);
        if (indexList != null && !indexList.isEmpty()) {
            Iterator<DEH> iterator = indexList.iterator();
            while (iterator.hasNext()) {
                DEH expr = iterator.next();
                proxy.setIndex(true);
                atom.append((DelayedExecutor)expr);
                proxy.setIndex(false);
                if (iterator.hasNext()) {
                    proxy.loadArray();
                    continue;
                }
                proxy.loadArrayItem();
            }
        }
        if (neg) {
            proxy.neg();
        }
        return atom;
    }

    @Rule(left="atom", value={"identifier", "LPAREN", "expressionList", "RPAREN"})
    protected DEH func(String identifier, List<DEH> funcArgs, @ParserContext(value="degrees") boolean degrees, @ParserContext(value="handler") MethodExpressionHandler handler) throws IOException {
        DEH atom = new DEH();
        ExpressionHandler proxy = (ExpressionHandler)atom.getProxy();
        ExecutableElement method = handler.findMethod(identifier, funcArgs.size());
        List<? extends VariableElement> parameters = method.getParameters();
        assert (funcArgs.size() == parameters.size());
        int index = 0;
        for (DEH expr : funcArgs) {
            atom.append((DelayedExecutor)expr);
            proxy.convertTo(parameters.get(index++).asType());
            if (!degrees || !degreeArgs.contains(method)) continue;
            proxy.invoke(El.getMethod(Math.class, (String)"toRadians", (Class[])new Class[]{Double.TYPE}));
        }
        proxy.invoke(method);
        proxy.convertFrom(method.getReturnType());
        if (degrees && degreeReturns.contains(method)) {
            proxy.invoke(El.getMethod(Math.class, (String)"toDegrees", (Class[])new Class[]{Double.TYPE}));
        }
        return atom;
    }

    @Terminal(expression="[a-zA-Z][a-zA-Z0-9_]*")
    protected abstract String identifier(String var1);

    @Terminal(expression="[\\+\\-]?[0-9]+")
    protected abstract String integer(String var1);

    @Terminal(expression="[\\+\\-]?[0-9]+(\\.[0-9]+)?([eE][\\+\\-]?[0-9]+)?")
    protected abstract String number(String var1);

    @Terminal(expression="[ \t\r\n]+")
    protected abstract void whiteSpace();

    public static void main(String[] args) {
        try {
            El.getTypeElement((CharSequence)MathExpressionParser.class.getCanonicalName());
            MathExpressionParser rp = (MathExpressionParser)GenClassFactory.getGenInstance(MathExpressionParser.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        degreeArgs.add(El.getMethod(Math.class, (String)"sin", (Class[])new Class[]{Double.TYPE}));
        degreeArgs.add(El.getMethod(Math.class, (String)"cos", (Class[])new Class[]{Double.TYPE}));
        degreeArgs.add(El.getMethod(Math.class, (String)"tan", (Class[])new Class[]{Double.TYPE}));
        degreeReturns.add(El.getMethod(Math.class, (String)"asin", (Class[])new Class[]{Double.TYPE}));
        degreeReturns.add(El.getMethod(Math.class, (String)"acos", (Class[])new Class[]{Double.TYPE}));
        degreeReturns.add(El.getMethod(Math.class, (String)"atan", (Class[])new Class[]{Double.TYPE}));
    }
}

