/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.grammar.impl;

import java.util.ArrayList;
import java.util.List;
import org.vesalainen.grammar.SyntheticBnfParserIntf;
import org.vesalainen.parser.annotation.GenClassname;
import org.vesalainen.parser.annotation.GrammarDef;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;

@GenClassname(value="org.vesalainen.grammar.impl.SyntheticBnfParserImpl")
@GrammarDef
public abstract class SyntheticBnfParser
implements SyntheticBnfParserIntf {
    @ParseMethod(start="expression")
    public abstract String parse(String var1);

    @Rule(left="expression", value={"symbol"})
    protected String plainSymbol(String symbol) {
        return symbol;
    }

    @Rule(left="expression", value={"expression", "'\u229b'"})
    protected String plainStar(String expr) {
        return expr + '*';
    }

    @Rule(left="expression", value={"expression", "'\u2295'"})
    protected String plainPlus(String expr) {
        return expr + '+';
    }

    @Rule(left="expression", value={"expression", "'\u00bf'"})
    protected String plainOpt(String expr) {
        return expr + '?';
    }

    @Rule(left="expression", value={"'\u03a3\\{'", "choiseList", "'\\}'"})
    protected String plainChoise(List<String> list) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (String choise : list) {
            if (first) {
                sb.append(choise);
                first = false;
                continue;
            }
            sb.append('|');
            sb.append(choise);
        }
        sb.append(')');
        return sb.toString();
    }

    @Rule(value={"expression"})
    protected List<String> choiseList(String type) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(type);
        return list;
    }

    @Rule(value={"choiseList", "pipe", "expression"})
    protected List<String> choiseList(List<String> typeList, String type) {
        typeList.add(type);
        return typeList;
    }

    @Rule(left="expression", value={"'\u03d5\\{'", "seqList", "'\\}'"})
    protected String plainSeq(List<String> list) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (String choise : list) {
            if (first) {
                sb.append(choise);
                first = false;
                continue;
            }
            sb.append(' ');
            sb.append(choise);
        }
        sb.append(')');
        return sb.toString();
    }

    @Rule(value={"expression"})
    protected List<String> seqList(String type) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(type);
        return list;
    }

    @Rule(value={"seqList", "comma", "expression"})
    protected List<String> seqList(List<String> typeList, String type) {
        typeList.add(type);
        return typeList;
    }

    @Terminal(expression="'[^']+'|`[^\u00b4]+\u00b4")
    protected String anonymousTerminal(String name) {
        name = name.substring(1, name.length() - 1);
        return "'" + name + "'";
    }

    @Terminal(expression="[\\x21-\\x26\\x2d-\\x3e\\x40-\\x5f\\x61-\\x7b\\x7e-\\x7f\\xC0-\\xD6\\xD8-\\xF6]+")
    protected String symbolName(String name) {
        return name;
    }

    @Terminal(expression="\\|")
    protected void pipe() {
    }

    @Terminal(expression="\\,")
    protected void comma() {
    }

    @Rules(value={@Rule(value={"symbolName"}), @Rule(value={"anonymousTerminal"})})
    protected String symbol(String name) {
        return name;
    }
}

