/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.grammar.impl;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.vesalainen.bcc.model.Typ;
import org.vesalainen.grammar.Grammar;
import org.vesalainen.grammar.SyntheticParserIntf;
import org.vesalainen.parser.annotation.GenClassname;
import org.vesalainen.parser.annotation.GrammarDef;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.regex.Regex;

@GenClassname(value="org.vesalainen.grammar.impl.SyntheticParserImpl")
@GrammarDef
public abstract class SyntheticParser
implements SyntheticParserIntf {
    public TypeMirror parse(String text, Grammar g) {
        try {
            return this.parseIt(text, g);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Problem with " + text, t);
        }
    }

    @ParseMethod(start="expression")
    protected abstract TypeMirror parseIt(String var1, @ParserContext(value="GRAMMAR") Grammar var2);

    @Rule(left="expression", value={"symbol"})
    protected TypeMirror plainSymbol(String symbol, @ParserContext(value="GRAMMAR") Grammar g) {
        return g.getTypeForNonterminal(symbol);
    }

    @Rule(left="expression", value={"expression", "'\u229b'"})
    protected TypeMirror plainStar(TypeMirror type) {
        return type;
    }

    @Rule(left="expression", value={"expression", "'\u2295'"})
    protected TypeMirror plainPlus(TypeMirror type) {
        return type;
    }

    @Rule(left="expression", value={"expression", "'\u00bf'"})
    protected TypeMirror plainOpt(TypeMirror type) {
        return type;
    }

    @Rule(left="expression", value={"'\u03a3\\{'", "choiseList", "'\\}'"})
    protected TypeMirror plainChoise(List<TypeMirror> typeList) {
        TypeMirror type = typeList.get(0);
        for (TypeMirror t : typeList) {
            if (Typ.isSameType((TypeMirror)t, (TypeMirror)type)) continue;
            throw new IllegalArgumentException("all choise types not the same");
        }
        return type;
    }

    @Rule(value={"expression"})
    protected List<TypeMirror> choiseList(TypeMirror type) {
        ArrayList<TypeMirror> list = new ArrayList<TypeMirror>();
        list.add(type);
        return list;
    }

    @Rule(value={"choiseList", "pipe", "expression"})
    protected List<TypeMirror> choiseList(List<TypeMirror> typeList, TypeMirror type) {
        typeList.add(type);
        return typeList;
    }

    @Rule(left="expression", value={"'\u03d5\\{'", "seqList", "'\\}'"})
    protected TypeMirror plainSeq(List<TypeMirror> typeList) {
        TypeMirror type = Typ.Void;
        for (TypeMirror t : typeList) {
            if (t.getKind() == TypeKind.VOID) continue;
            if (type.getKind() != TypeKind.VOID) {
                throw new IllegalArgumentException("all one seq type != void allowed");
            }
            type = t;
        }
        return type;
    }

    @Rule(value={"expression"})
    protected List<TypeMirror> seqList(TypeMirror type) {
        ArrayList<TypeMirror> list = new ArrayList<TypeMirror>();
        list.add(type);
        return list;
    }

    @Rule(value={"seqList", "comma", "expression"})
    protected List<TypeMirror> seqList(List<TypeMirror> typeList, TypeMirror type) {
        typeList.add(type);
        return typeList;
    }

    @Terminal(expression="'[^']+'|`[^\u00b4]+\u00b4")
    protected String anonymousTerminal(String name, @ParserContext(value="GRAMMAR") Grammar g) {
        name = name.substring(1, name.length() - 1);
        g.addAnonymousTerminal(name, new Regex.Option[0]);
        return "'" + name + "'";
    }

    @Terminal(expression="[\\x21-\\x26\\x2d-\\x3e\\x40-\\x5f\\x61-\\x7b\\x7e-\\x7f\\xC0-\\xD6\\xD8-\\xF6]+")
    protected String symbolName(String name) {
        return name;
    }

    @Terminal(expression="\\|")
    protected abstract void pipe();

    @Terminal(expression="\\,")
    protected abstract void comma();

    @Rules(value={@Rule(value={"symbolName"}), @Rule(value={"anonymousTerminal"})})
    protected String symbol(String name) {
        return name;
    }
}

