/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.regex.impl;

import java.util.HashSet;
import org.vesalainen.grammar.state.NFA;
import org.vesalainen.grammar.state.NFAState;
import org.vesalainen.grammar.state.Scope;
import org.vesalainen.parser.annotation.GenClassname;
import org.vesalainen.parser.annotation.GrammarDef;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.regex.Quantifier;
import org.vesalainen.regex.Range;
import org.vesalainen.regex.RangeSet;
import org.vesalainen.regex.Regex;
import org.vesalainen.regex.RegexParserIntf;

@GenClassname(value="org.vesalainen.regex.impl.RegexParserImpl")
@GrammarDef
public abstract class RegexGrammar<T>
implements RegexParserIntf<T> {
    private static final String REGEXCONTROL = "\\[\\]\\(\\)\\\\\\-\\^\\*\\+\\?\\|\\.\\{\\}\\&\\$\\,";

    public NFA<T> createNFA(Scope<NFAState<T>> scope, String expression, T reducer, Regex.Option ... options) {
        Literal literal = new Literal();
        NFA nfa = this.parse(expression, scope, literal, options);
        if (Regex.Option.supports((Regex.Option[])options, (Regex.Option)Regex.Option.FIXED_ENDER)) {
            NFA.modifyFixedEnder((NFA)nfa);
        }
        NFAState last = nfa.getLast();
        last.setToken(reducer);
        if (literal.isLiteral()) {
            last.changePriority(1);
        }
        if (Regex.Option.supports((Regex.Option[])options, (Regex.Option)Regex.Option.ACCEPT_IMMEDIATELY)) {
            last.setAcceptImmediately(true);
        }
        return nfa;
    }

    @ParseMethod(start="regexp")
    protected abstract NFA parse(String var1, @ParserContext(value="FACTORY") Scope<NFAState<T>> var2, @ParserContext(value="LITERAL") Literal var3, Regex.Option ... var4);

    @Rule(value={"branch"})
    protected NFA regexp(NFA branch) {
        return branch;
    }

    @Rule(value={"regexp", "'\\|'", "branch"})
    protected NFA regexp(NFA branch, NFA piece, @ParserContext(value="FACTORY") Scope<NFAState<T>> factory, @ParserContext(value="LITERAL") Literal literal) {
        literal.setLiteral(false);
        return new NFA(factory, branch, piece);
    }

    @Rule(value={"branch", "piece"})
    protected NFA branch(NFA<T> branch, NFA<T> piece) {
        branch.concat(piece);
        return branch;
    }

    @Rule(value={"piece"})
    protected NFA<T> branch(NFA<T> piece) {
        return piece;
    }

    @Rule(left="piece", value={"'\\('", "regexp", "'\\)'", "quantifier"})
    protected NFA<T> piece(NFA<T> atom, Quantifier quantifier, @ParserContext(value="FACTORY") Scope<NFAState<T>> factory, @ParserContext(value="LITERAL") Literal literal) {
        NFA r;
        int ii;
        literal.setLiteral(false);
        NFA result = null;
        for (ii = 0; ii < quantifier.getMin(); ++ii) {
            r = new NFA(factory, atom);
            if (result == null) {
                result = r;
                continue;
            }
            result.concat(r);
        }
        if (quantifier.getMax() == Integer.MAX_VALUE) {
            NFA r2 = new NFA(factory, atom);
            r2.star();
            if (result == null) {
                result = r2;
            } else {
                result.concat(r2);
            }
        } else {
            for (ii = quantifier.getMin(); ii < quantifier.getMax(); ++ii) {
                r = new NFA(factory, atom);
                r.opt();
                if (result == null) {
                    result = r;
                    continue;
                }
                result.concat(r);
            }
        }
        return result;
    }

    @Rule(value={"atom", "quantifier"})
    protected NFA<T> piece(RangeSet atom, Quantifier quantifier, @ParserContext(value="FACTORY") Scope<NFAState<T>> factory, @ParserContext(value="LITERAL") Literal literal) {
        if (quantifier.getMin() != 1 || quantifier.getMax() != 1) {
            literal.setLiteral(false);
        }
        NFA result = null;
        for (int ii = 0; ii < quantifier.getMin(); ++ii) {
            NFA r = new NFA(factory, atom);
            if (result == null) {
                result = r;
                continue;
            }
            result.concat(r);
        }
        if (quantifier.getMax() == Integer.MAX_VALUE) {
            NFA r = new NFA(factory, atom);
            r.star();
            if (result == null) {
                result = r;
            } else {
                result.concat(r);
            }
        } else {
            HashSet<NFAState> skippers = new HashSet<NFAState>();
            for (int ii = quantifier.getMin(); ii < quantifier.getMax(); ++ii) {
                NFA r = new NFA(factory, atom);
                skippers.add(r.getFirst());
                if (result == null) {
                    result = r;
                    continue;
                }
                result.concat(r);
            }
            for (NFAState s : skippers) {
                s.addEpsilon(result.getLast());
            }
        }
        return result;
    }

    @Rules(value={@Rule(value={"charRange"}), @Rule(value={"rangeDef"}), @Rule(value={"boundaryMatcher"})})
    protected RangeSet atom(RangeSet rs) {
        return rs;
    }

    @Rule(value={"'\\['", "rs1", "'\\]'"})
    protected RangeSet rangeDef(RangeSet rs) {
        return rs;
    }

    @Rules(value={@Rule(value={"posRange"}), @Rule(value={"negRange"}), @Rule(value={"inclusiveRange"}), @Rule(value={"intersectRange"})})
    protected RangeSet rs1(RangeSet rs) {
        return rs;
    }

    @Rule(value={"rangeList"})
    protected RangeSet posRange(RangeSet rs) {
        return rs;
    }

    @Rule(value={"'\\^'", "rangeList"})
    protected RangeSet negRange(RangeSet rs) {
        return rs.complement();
    }

    @Rule(value={"rangeList", "'\\['", "rs1", "'\\]'"})
    protected RangeSet inclusiveRange(RangeSet rs1, RangeSet rs2) {
        rs1.add(rs2);
        return rs1;
    }

    @Rule(value={"rangeList", "'\\&\\&'", "'\\['", "rs1", "'\\]'"})
    protected RangeSet intersectRange(RangeSet rs1, RangeSet rs2) {
        return RangeSet.intersect((RangeSet[])new RangeSet[]{rs1, rs2});
    }

    @Rule(value={"rangeListEntry"})
    protected RangeSet rangeList(RangeSet rs) {
        return rs;
    }

    @Rule(value={"rangeList", "rangeListEntry"})
    protected RangeSet rangeList(RangeSet rs1, RangeSet rs2) {
        rs1.add(rs2);
        return rs1;
    }

    @Rules(value={@Rule(value={"charRange"}), @Rule(value={"negativeCharRange"}), @Rule(value={"dashRange"})})
    protected RangeSet rangeListEntry(RangeSet rs) {
        return rs;
    }

    @Rule(value={"'\\.'"})
    protected RangeSet charRange() {
        RangeSet rs = new RangeSet();
        rs.add(0, Integer.MAX_VALUE);
        return rs;
    }

    @Rule(value={"character"})
    protected RangeSet charRange(int cc, Regex.Option ... options) {
        RangeSet rs = new RangeSet(cc);
        if (Regex.Option.supports((Regex.Option[])options, (Regex.Option)Regex.Option.CASE_INSENSITIVE)) {
            if (Character.isLowerCase(cc)) {
                rs.add(Character.toUpperCase(cc));
            } else if (Character.isUpperCase(cc)) {
                rs.add(Character.toLowerCase(cc));
            }
        }
        return rs;
    }

    @Rules(value={@Rule(value={"'\\\\'", "characterClass"}), @Rule(value={"'\\\\'", "'p'", "posixCharacterClass"})})
    protected RangeSet charRange(RangeSet rs) {
        return rs;
    }

    @Rules(value={@Rule(value={"'\\\\'", "'P'", "posixCharacterClass"})})
    protected RangeSet negativeCharRange(RangeSet rs) {
        return rs.complement();
    }

    @Rule(value={"character", "'\\-'", "character"})
    protected RangeSet dashRange(int from, int to, Regex.Option ... options) {
        RangeSet rs = new RangeSet();
        if (Regex.Option.supports((Regex.Option[])options, (Regex.Option)Regex.Option.CASE_INSENSITIVE)) {
            for (int cc = from; cc <= to; ++cc) {
                rs.add(cc);
                if (Character.isLowerCase(cc)) {
                    rs.add(Character.toUpperCase(cc));
                    continue;
                }
                if (!Character.isUpperCase(cc)) continue;
                rs.add(Character.toLowerCase(cc));
            }
        } else {
            rs.add(from, to + 1);
        }
        return rs;
    }

    @Rules(value={@Rule(value={"star"}), @Rule(value={"plus"}), @Rule(value={"opt"}), @Rule(value={"braceQ1"}), @Rule(value={"braceQ2"})})
    protected Quantifier quantifier(Quantifier q) {
        return q;
    }

    @Rule
    protected Quantifier quantifier() {
        return new Quantifier(1);
    }

    @Rule(value={"'\\{'", "digit", "'\\}'"})
    protected Quantifier braceQ1(int i) {
        return new Quantifier(i);
    }

    @Rule(value={"'\\{'", "digit", "'\\,'", "'\\}'"})
    protected Quantifier braceQ2(int i) {
        return new Quantifier(i, Integer.MAX_VALUE);
    }

    @Rule(value={"'\\{'", "digit", "'\\,'", "digit", "'\\}'"})
    protected Quantifier braceQ2(int min, int max) {
        return new Quantifier(min, max);
    }

    @Rules(value={@Rule(value={"beginningOfLine"}), @Rule(value={"endOfLine"}), @Rule(value={"wordBoundary"}), @Rule(value={"nonWordBoundary"}), @Rule(value={"beginningOfInput"}), @Rule(value={"endOfPreviousMatch"}), @Rule(value={"endOfInputOrLine"}), @Rule(value={"endOfInput"})})
    protected RangeSet boundaryMatcher(Range range) {
        RangeSet rs = new RangeSet();
        rs.add(range);
        return rs;
    }

    @Rule(value={"'\\^'"})
    protected Range beginningOfLine() {
        return new Range(Range.BoundaryType.BOL);
    }

    @Rule(value={"'\\$'"})
    protected Range endOfLine() {
        return new Range(Range.BoundaryType.EOL);
    }

    @Rule(value={"'\\\\'", "'b'"})
    protected Range wordBoundary() {
        return new Range(Range.BoundaryType.WB);
    }

    @Rule(value={"'\\\\'", "'B'"})
    protected Range nonWordBoundary() {
        return new Range(Range.BoundaryType.NWB);
    }

    @Rule(value={"'\\\\'", "'A'"})
    protected Range beginningOfInput() {
        return new Range(Range.BoundaryType.BOI);
    }

    @Rule(value={"'\\\\'", "'G'"})
    protected Range endOfPreviousMatch() {
        return new Range(Range.BoundaryType.EOPM);
    }

    @Rule(value={"'\\\\'", "'Z'"})
    protected Range endOfInputOrLine() {
        return new Range(Range.BoundaryType.EOIL);
    }

    @Rule(value={"'\\\\'", "'z'"})
    protected Range endOfInput() {
        return new Range(Range.BoundaryType.EOI);
    }

    @Terminal(expression="\\*")
    protected Quantifier star() {
        return new Quantifier(0, Integer.MAX_VALUE);
    }

    @Terminal(expression="\\?")
    protected Quantifier opt() {
        return new Quantifier(0, 1);
    }

    @Terminal(expression="\\+")
    protected Quantifier plus() {
        return new Quantifier(1, Integer.MAX_VALUE);
    }

    @Terminal(expression="[0-9]+")
    protected int digit(int i) {
        return i;
    }

    @Terminal(expression="[1-9]")
    protected int singleDigit(int i) {
        return i;
    }

    @Rules(value={@Rule(value={"'\\\\'", "escaped"}), @Rule(value={"notRegexControl"})})
    protected int character(int cc) {
        return cc;
    }

    @Rules(value={@Rule(value={"tab"}), @Rule(value={"nl"}), @Rule(value={"cr"}), @Rule(value={"ff"}), @Rule(value={"alert"}), @Rule(value={"esc"}), @Rule(value={"octal"}), @Rule(value={"hex"}), @Rule(value={"hex2"}), @Rule(value={"'c'", "control"}), @Rule(value={"regexControlCharacter"})})
    protected int escaped(int cc) {
        return cc;
    }

    @Terminal(expression="[dDsSwW]")
    protected RangeSet characterClass(char cc) {
        RangeSet rs = new RangeSet();
        switch (cc) {
            case 'd': {
                rs = new RangeSet();
                rs.add(new Range(48, 58));
                return rs;
            }
            case 'D': {
                rs = new RangeSet();
                rs.add(new Range(48, 58));
                return rs.complement();
            }
            case 's': {
                rs = new RangeSet();
                rs.add(new Range(32));
                rs.add(new Range(9));
                rs.add(new Range(10));
                rs.add(new Range(11));
                rs.add(new Range(12));
                rs.add(new Range(13));
                return rs;
            }
            case 'S': {
                rs = new RangeSet();
                rs.add(new Range(32));
                rs.add(new Range(9));
                rs.add(new Range(10));
                rs.add(new Range(11));
                rs.add(new Range(12));
                rs.add(new Range(13));
                return rs.complement();
            }
            case 'w': {
                rs = new RangeSet();
                rs.add(new Range(97, 123));
                rs.add(new Range(65, 91));
                rs.add(new Range(48, 58));
                rs.add(new Range(95));
                return rs;
            }
            case 'W': {
                rs = new RangeSet();
                rs.add(new Range(97, 123));
                rs.add(new Range(65, 91));
                rs.add(new Range(48, 58));
                rs.add(new Range(95));
                return rs.complement();
            }
        }
        throw new IllegalArgumentException(cc + "unexpected");
    }

    @Rules(value={@Rule(value={"posixLower"}), @Rule(value={"posixUpper"}), @Rule(value={"posixASCII"}), @Rule(value={"posixAlpha"}), @Rule(value={"posixDigit"}), @Rule(value={"posixAlnum"}), @Rule(value={"posixPunct"}), @Rule(value={"posixGraph"}), @Rule(value={"posixPrint"}), @Rule(value={"posixBlank"}), @Rule(value={"posixCntrl"}), @Rule(value={"posixXDigit"}), @Rule(value={"posixSpace"}), @Rule(value={"javaLowerCase"}), @Rule(value={"javaUpperCase"}), @Rule(value={"javaWhitespace"}), @Rule(value={"javaMirrored"}), @Rule(value={"unicodeBlock"}), @Rule(value={"unicodeCategory"}), @Rule(value={"unicodeLetter"})})
    protected RangeSet posixCharacterClass(RangeSet rs) {
        return rs;
    }

    @Terminal(expression="\\{Lower\\}")
    protected RangeSet posixLower() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(97, 123));
        return rs;
    }

    @Terminal(expression="\\{Upper\\}")
    protected RangeSet posixUpper(Regex.Option ... options) {
        if (Regex.Option.supports((Regex.Option[])options, (Regex.Option)Regex.Option.CASE_INSENSITIVE)) {
            return this.posixLower();
        }
        RangeSet rs = new RangeSet();
        rs.add(new Range(65, 91));
        return rs;
    }

    @Terminal(expression="\\{ASCII\\}")
    protected RangeSet posixASCII() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(0, 128));
        return rs;
    }

    @Terminal(expression="\\{Alpha\\}")
    protected RangeSet posixAlpha() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(97, 123));
        rs.add(new Range(65, 91));
        return rs;
    }

    @Terminal(expression="\\{Digit\\}")
    protected RangeSet posixDigit() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(48, 58));
        return rs;
    }

    @Terminal(expression="\\{Alnum\\}")
    protected RangeSet posixAlnum() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(97, 123));
        rs.add(new Range(65, 91));
        rs.add(new Range(48, 58));
        return rs;
    }

    @Terminal(expression="\\{Punct\\}")
    protected RangeSet posixPunct() {
        RangeSet rs = new RangeSet();
        rs.add("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".toCharArray());
        return rs;
    }

    @Terminal(expression="\\{Graph\\}")
    protected RangeSet posixGraph() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(97, 123));
        rs.add(new Range(65, 91));
        rs.add(new Range(48, 58));
        rs.add("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".toCharArray());
        return rs;
    }

    @Terminal(expression="\\{Print\\}")
    protected RangeSet posixPrint() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(97, 123));
        rs.add(new Range(65, 91));
        rs.add(new Range(48, 58));
        rs.add("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".toCharArray());
        rs.add(32);
        return rs;
    }

    @Terminal(expression="\\{Blank\\}")
    protected RangeSet posixBlank() {
        RangeSet rs = new RangeSet();
        rs.add(32);
        rs.add(9);
        return rs;
    }

    @Terminal(expression="\\{Cntrl\\}")
    protected RangeSet posixCntrl() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(0, 32));
        rs.add(127);
        return rs;
    }

    @Terminal(expression="\\{XDigit\\}")
    protected RangeSet posixXDigit() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(48, 58));
        rs.add(new Range(97, 103));
        rs.add(new Range(65, 71));
        return rs;
    }

    @Terminal(expression="\\{Space\\}")
    protected RangeSet posixSpace() {
        RangeSet rs = new RangeSet();
        rs.add(new Range(32));
        rs.add(new Range(9));
        rs.add(new Range(10));
        rs.add(new Range(11));
        rs.add(new Range(12));
        rs.add(new Range(13));
        return rs;
    }

    @Terminal(expression="\\{javaLowerCase\\}")
    protected RangeSet javaLowerCase() {
        RangeSet rs = new RangeSet();
        for (int ii = 0; ii < 65535; ++ii) {
            char cc = (char)ii;
            if (!Character.isLowerCase(cc)) continue;
            rs.add(new Range((int)cc));
        }
        return rs;
    }

    @Terminal(expression="\\{javaUpperCase\\}")
    protected RangeSet javaUpperCase(Regex.Option ... options) {
        if (Regex.Option.supports((Regex.Option[])options, (Regex.Option)Regex.Option.CASE_INSENSITIVE)) {
            return this.javaLowerCase();
        }
        RangeSet rs = new RangeSet();
        for (int ii = 0; ii < 65535; ++ii) {
            char cc = (char)ii;
            if (!Character.isUpperCase(cc)) continue;
            rs.add(new Range((int)cc));
        }
        return rs;
    }

    @Terminal(expression="\\{javaWhitespace\\}")
    protected RangeSet javaWhitespace() {
        RangeSet rs = new RangeSet();
        for (int ii = 0; ii < 65535; ++ii) {
            char cc = (char)ii;
            if (!Character.isWhitespace(cc)) continue;
            rs.add(new Range((int)cc));
        }
        return rs;
    }

    @Terminal(expression="\\{javaMirrored\\}")
    protected RangeSet javaMirrored() {
        RangeSet rs = new RangeSet();
        for (int ii = 0; ii < 65535; ++ii) {
            char cc = (char)ii;
            if (!Character.isMirrored(cc)) continue;
            rs.add(new Range((int)cc));
        }
        return rs;
    }

    @Terminal(expression="\\{L\\}|\\{IsL\\}")
    protected RangeSet unicodeLetter() {
        RangeSet rs = new RangeSet();
        for (int ii = 0; ii < 65535; ++ii) {
            char cc = (char)ii;
            if (!Character.isLetter(cc)) continue;
            rs.add(new Range((int)cc));
        }
        return rs;
    }

    @Rule(value={"'\\{In'", "blockName", "'\\}'"})
    protected RangeSet unicodeBlock(String blockName) {
        Character.UnicodeBlock b = Character.UnicodeBlock.forName(blockName);
        RangeSet rs = new RangeSet();
        for (int ii = 0; ii < 65535; ++ii) {
            char cc = (char)ii;
            if (!b.equals(Character.UnicodeBlock.of(cc))) continue;
            rs.add(new Range((int)cc));
        }
        return rs;
    }

    @Rule(value={"category"})
    protected RangeSet unicodeCategory(int category) {
        RangeSet rs = new RangeSet();
        for (int ii = 0; ii < 65535; ++ii) {
            char cc = (char)ii;
            if (Character.getType(cc) != category) continue;
            rs.add(new Range((int)cc));
        }
        return rs;
    }

    @Rules(value={@Rule(value={"combiningSpacingMark"}), @Rule(value={"connectorPunctuation"}), @Rule(value={"controlCategory"}), @Rule(value={"currencySymbol"}), @Rule(value={"dashPunctuation"}), @Rule(value={"decimalDigitNumber"}), @Rule(value={"enclosingMark"}), @Rule(value={"endPunctuation"}), @Rule(value={"finalQuotePunctuation"}), @Rule(value={"format"}), @Rule(value={"initialQuotePunctuation"}), @Rule(value={"letterNumber"}), @Rule(value={"lineSeparator"}), @Rule(value={"lowercaseLetter"}), @Rule(value={"mathSymbol"}), @Rule(value={"modifierLetter"}), @Rule(value={"modifierSymbol"}), @Rule(value={"nonSpacingMark"}), @Rule(value={"otherLetter"}), @Rule(value={"otherNumber"}), @Rule(value={"otherPunctuation"}), @Rule(value={"otherSymbol"}), @Rule(value={"paragraphSeparator"}), @Rule(value={"privateUse"}), @Rule(value={"spaceSeparator"}), @Rule(value={"startPunctuation"}), @Rule(value={"surrogate"}), @Rule(value={"titleCaseLetter"}), @Rule(value={"unassigned"}), @Rule(value={"uppercaseLetter"})})
    protected int category(int category) {
        return category;
    }

    @Terminal(expression="\\{Mc\\}|\\{IsMc\\}")
    protected int combiningSpacingMark() {
        return 8;
    }

    @Terminal(expression="\\{Pc\\}|\\{IsPc\\}")
    protected int connectorPunctuation() {
        return 23;
    }

    @Terminal(expression="\\{Cc\\}|\\{IsCc\\}")
    protected int controlCategory() {
        return 15;
    }

    @Terminal(expression="\\{Sc\\}|\\{IsSc\\}")
    protected int currencySymbol() {
        return 26;
    }

    @Terminal(expression="\\{Pd\\}|\\{IsPd\\}")
    protected int dashPunctuation() {
        return 20;
    }

    @Terminal(expression="\\{Nd\\}|\\{IsNd\\}")
    protected int decimalDigitNumber() {
        return 9;
    }

    @Terminal(expression="\\{Me\\}|\\{IsMe\\}")
    protected int enclosingMark() {
        return 7;
    }

    @Terminal(expression="\\{Pe\\}|\\{IsPe\\}")
    protected int endPunctuation() {
        return 22;
    }

    @Terminal(expression="\\{Pf\\}|\\{IsPf\\}")
    protected int finalQuotePunctuation() {
        return 30;
    }

    @Terminal(expression="\\{Cf\\}|\\{IsCf\\}")
    protected int format() {
        return 16;
    }

    @Terminal(expression="\\{Pi\\}|\\{IsPi\\}")
    protected int initialQuotePunctuation() {
        return 29;
    }

    @Terminal(expression="\\{Nl\\}|\\{IsNl\\}")
    protected int letterNumber() {
        return 10;
    }

    @Terminal(expression="\\{Zl\\}|\\{IsZl\\}")
    protected int lineSeparator() {
        return 13;
    }

    @Terminal(expression="\\{Ll\\}|\\{IsLl\\}")
    protected int lowercaseLetter() {
        return 2;
    }

    @Terminal(expression="\\{Sm\\}|\\{IsSm\\}")
    protected int mathSymbol() {
        return 25;
    }

    @Terminal(expression="\\{Lm\\}|\\{IsLm\\}")
    protected int modifierLetter() {
        return 4;
    }

    @Terminal(expression="\\{Sk\\}|\\{IsSk\\}")
    protected int modifierSymbol() {
        return 27;
    }

    @Terminal(expression="\\{Mn\\}|\\{IsMn\\}")
    protected int nonSpacingMark() {
        return 6;
    }

    @Terminal(expression="\\{Lo\\}|\\{IsLo\\}")
    protected int otherLetter() {
        return 5;
    }

    @Terminal(expression="\\{No\\}|\\{IsNo\\}")
    protected int otherNumber() {
        return 11;
    }

    @Terminal(expression="\\{Po\\}|\\{IsPo\\}")
    protected int otherPunctuation() {
        return 24;
    }

    @Terminal(expression="\\{So\\}|\\{IsSo\\}")
    protected int otherSymbol() {
        return 28;
    }

    @Terminal(expression="\\{Zp\\}|\\{IsZp\\}")
    protected int paragraphSeparator() {
        return 14;
    }

    @Terminal(expression="\\{Co\\}|\\{IsCo\\}")
    protected int privateUse() {
        return 18;
    }

    @Terminal(expression="\\{Zs\\}|\\{IsZs\\}")
    protected int spaceSeparator() {
        return 12;
    }

    @Terminal(expression="\\{Ps\\}|\\{IsPs\\}")
    protected int startPunctuation() {
        return 21;
    }

    @Terminal(expression="\\{Cs\\}|\\{IsCs\\}")
    protected int surrogate() {
        return 19;
    }

    @Terminal(expression="\\{Lt\\}|\\{IsLt\\}")
    protected int titleCaseLetter() {
        return 3;
    }

    @Terminal(expression="\\{Cn\\}|\\{IsCn\\}")
    protected int unassigned() {
        return 0;
    }

    @Terminal(expression="\\{Lu\\}|\\{IsLu\\}")
    protected int uppercaseLetter(Regex.Option ... options) {
        if (Regex.Option.supports((Regex.Option[])options, (Regex.Option)Regex.Option.CASE_INSENSITIVE)) {
            return this.lowercaseLetter();
        }
        return 1;
    }

    @Terminal(expression="[a-zA-Z0-9_\\- ]+")
    protected String blockName(String blockName) {
        return blockName;
    }

    @Terminal(expression="[^\\[\\]\\(\\)\\\\\\-\\^\\*\\+\\?\\|\\.\\{\\}\\&\\$\\,]")
    protected int notRegexControl(char cc) {
        return cc;
    }

    @Terminal(expression="[\\[\\]\\(\\)\\\\\\-\\^\\*\\+\\?\\|\\.\\{\\}\\&\\$\\,]")
    protected int regexControlCharacter(char cc) {
        return cc;
    }

    @Terminal(expression="t")
    protected int tab() {
        return 9;
    }

    @Terminal(expression="n")
    protected int nl() {
        return 10;
    }

    @Terminal(expression="r")
    protected int cr() {
        return 13;
    }

    @Terminal(expression="f")
    protected int ff() {
        return 12;
    }

    @Terminal(expression="a")
    protected int alert() {
        return 7;
    }

    @Terminal(expression="e")
    protected int esc() {
        return 27;
    }

    @Terminal(expression="0[0-7]|0[0-7]{2}|0[0-3][0-7]{2}")
    protected int octal(String s) {
        return Integer.parseInt(s.substring(1), 8);
    }

    @Terminal(expression="x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}")
    protected int hex(String s) {
        return Integer.parseInt(s.substring(1), 16);
    }

    @Terminal(expression="x\\{[0-9a-fA-F]+\\}")
    protected int hex2(String s) {
        return Integer.parseInt(s.substring(2, s.length() - 1), 16);
    }

    @Terminal(expression="[A-Z\\[\\]\\\\\\^_]")
    protected int control(char cc) {
        return cc - 65 + 1;
    }

    public static class Literal {
        private boolean literal = true;

        public boolean isLiteral() {
            return this.literal;
        }

        public void setLiteral(boolean literal) {
            this.literal = literal;
        }
    }
}

