/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.grammar.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.vesalainen.bcc.model.El;
import org.vesalainen.grammar.BnfGrammarIntf;
import org.vesalainen.grammar.Grammar;
import org.vesalainen.parser.annotation.GenClassname;
import org.vesalainen.parser.annotation.GenRegex;
import org.vesalainen.parser.annotation.GrammarDef;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.parser.util.Reducers;
import org.vesalainen.regex.Regex;

@GenClassname(value="org.vesalainen.grammar.impl.BnfParser")
@GrammarDef
public abstract class BnfGrammar
implements BnfGrammarIntf {
    @GenRegex(value="[\\x00-\\xff]+")
    protected static Regex inputCheck;

    @Rules(value={@Rule, @Rule(value={"bnf", "rule"})})
    protected void bnf() {
    }

    @Rule(value={"symbol", "products", "seqs", "ln"})
    protected void rule(String symbol, List<String> seq, @ParserContext(value="GRAMMAR") Grammar g) {
        g.addRule(symbol, seq);
    }

    @Rule(value={"choicePart"})
    protected String choice(List<String> choice, @ParserContext(value="GRAMMAR") Grammar g) throws IOException {
        String nt = BnfGrammar.makeName(choice, '\u03a3', '|');
        ExecutableElement reducer = El.getMethod(Reducers.class, (String)"get", (Class[])new Class[]{Object.class});
        if (reducer == null) {
            throw new IllegalArgumentException(Reducers.class.getCanonicalName() + ".get() not found");
        }
        for (String c : choice) {
            g.addSyntheticRule(reducer, nt, new String[]{c});
        }
        return nt;
    }

    @Rule(value={"seqPart"})
    protected String seq(List<String> seq, @ParserContext(value="GRAMMAR") Grammar g) throws IOException {
        String nt = BnfGrammar.makeName(seq, '\u03d5', ',');
        ExecutableElement reducer = El.getMethod(Reducers.class, (String)"get", (Class[])new Class[]{Object.class});
        if (reducer == null) {
            throw new IllegalArgumentException(Reducers.class.getCanonicalName() + ".get() not found");
        }
        g.addSyntheticRule(reducer, nt, seq);
        return nt;
    }

    @Rules(value={@Rule(value={"symbol", "quantifier"}), @Rule(value={"choice", "quantifier"}), @Rule(value={"seq", "quantifier"})})
    protected String part(String nt, char quantifier, @ParserContext(value="GRAMMAR") Grammar g) throws IOException {
        try {
            return Grammar.quantifierRules((String)nt, (char)quantifier, (Grammar)g);
        }
        catch (NoSuchMethodException ex) {
            throw new IOException(ex);
        }
    }

    @Rule(value={"'\\('", "choices", "'\\)'"})
    protected List<String> choicePart(List<String> choices) {
        return choices;
    }

    @Rule(value={"part", "or", "part"})
    protected List<String> choices(String cp1, String cp2) {
        ArrayList<String> choices = new ArrayList<String>();
        choices.add(cp1);
        choices.add(cp2);
        return choices;
    }

    @Rule(value={"choices", "or", "part"})
    protected List<String> choices(List<String> choices, String symbol) {
        choices.add(symbol);
        return choices;
    }

    @Rule(value={"'\\('", "seqs", "'\\)'"})
    protected List<String> seqPart(List<String> seqs) {
        return seqs;
    }

    @Rule(value={"part"})
    protected List<String> seqs(String symbol) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(symbol);
        return list;
    }

    @Rule(value={"seqs", "part"})
    protected List<String> seqs(List<String> seqs, String symbol) {
        seqs.add(symbol);
        return seqs;
    }

    @Rule
    protected char quantifier() {
        return '\u0000';
    }

    @Rule(value={"quantifierChar"})
    protected char quantifier(char quantifier) {
        return quantifier;
    }

    @Terminal(expression="[\\+\\*\\?]")
    protected char quantifierChar(char quantifier) {
        return quantifier;
    }

    @Terminal(expression="'[^']+'|`[^\u00b4]+\u00b4")
    protected String anonymousTerminal(String name, @ParserContext(value="GRAMMAR") Grammar g) {
        name = name.substring(1, name.length() - 1);
        g.addAnonymousTerminal(name, new Regex.Option[0]);
        return "'" + name + "'";
    }

    @Terminal(expression="[\\x21-\\x26\\x2d-\\x3e\\x40-\\x5f\\x61-\\x7b\\x7e-\\x7f\\xC0-\\xD6\\xD8-\\xF6]+")
    protected String symbolName(String name) {
        return name;
    }

    @Rules(value={@Rule(value={"symbolName"}), @Rule(value={"anonymousTerminal"})})
    protected String symbol(String name) {
        return name;
    }

    @Terminal(expression="[ \t]+")
    protected void s() {
    }

    @Rule(value={"'[\r\n]+'"})
    protected void ln() {
    }

    @Rule(value={"'\\|'"})
    protected void or() {
    }

    @Rule(value={"'::='"})
    protected void products() {
    }

    @ParseMethod(start="bnf", whiteSpace={"s"})
    public void parseBnf(CharSequence text, @ParserContext(value="GRAMMAR") Grammar g) {
        throw new UnsupportedOperationException();
    }

    public List<String> parseRhs(String text, @ParserContext(value="GRAMMAR") Grammar g) {
        if (inputCheck != null) {
            inputCheck.match((CharSequence)text);
        }
        return this.parseRhsString(text, g);
    }

    @ParseMethod(start="seqs", whiteSpace={"s"})
    protected abstract List<String> parseRhsString(String var1, @ParserContext(value="GRAMMAR") Grammar var2);

    private static String makeName(List<String> list, char prefix, char separator) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append('{');
        for (String str : list) {
            if (sb.length() > 2) {
                sb.append(separator);
            }
            sb.append(str);
        }
        sb.append('}');
        return sb.toString();
    }
}

