/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.grammar.math;

import java.io.IOException;
import java.time.Clock;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.vesalainen.grammar.math.BooleanMathExpression;
import org.vesalainen.util.AbstractStateMachine;

public abstract class AbstractMathStateMachine
extends AbstractStateMachine<BooleanMathExpression, AbstractStateMachine.State> {
    public static final String START_TIME = "$startTime";
    public static final String ELAPSED_TIME = "$elapsedTime";
    public static final String STATE_START_TIME = "$stateStartTime";
    public static final String STATE_ELAPSED_TIME = "$stateElapsedTime";
    private boolean useDegrees;
    private Set<String> variables = new HashSet<String>();
    private Set<String> active = new HashSet<String>();
    private Set<String> reg = new HashSet<String>();

    public AbstractMathStateMachine(String start) {
        this(start, true);
    }

    public AbstractMathStateMachine(String start, boolean useDegrees) {
        this(start, Clock::systemDefaultZone, useDegrees);
    }

    public AbstractMathStateMachine(String start, Supplier<Clock> clockSupplier, boolean useDegrees) {
        super(start, clockSupplier);
        this.useDegrees = useDegrees;
    }

    public void addTransition(String from, String condition, String to) {
        Expression expression = new Expression(condition, this.useDegrees);
        super.addTransition(from, (BooleanSupplier)expression, to);
    }

    public Set<String> getCurrentVariables() throws Exception {
        this.variables.clear();
        this.getCurrentConditions().stream().forEach(bme -> this.variables.addAll(bme.getVariables()));
        return this.variables;
    }

    protected abstract double getVariable(String var1) throws IOException;

    public void evaluate() throws Exception {
        Set<String> cur = this.getCurrentVariables();
        this.reg.clear();
        this.reg.addAll(cur);
        this.reg.removeAll(this.active);
        this.register(this.reg);
        this.active.addAll(this.reg);
        super.evaluate();
        cur = this.getCurrentVariables();
        this.reg.clear();
        this.reg.addAll(this.active);
        this.reg.removeAll(cur);
        this.unregister(this.reg);
        this.active.removeAll(this.reg);
    }

    protected abstract void register(Set<String> var1);

    protected abstract void unregister(Set<String> var1);

    private class Expression
    extends BooleanMathExpression {
        public Expression(String expression, boolean degrees) {
            super(expression, degrees);
        }

        protected double getVariable(String identifier) throws IOException {
            switch (identifier) {
                case "$startTime": {
                    return AbstractMathStateMachine.this.getStartTime();
                }
                case "$elapsedTime": {
                    return AbstractMathStateMachine.this.getElapsedTime();
                }
                case "$stateStartTime": {
                    return AbstractMathStateMachine.this.getStateStartTime();
                }
                case "$stateElapsedTime": {
                    return AbstractMathStateMachine.this.getStateElapsedTime();
                }
            }
            return AbstractMathStateMachine.this.getVariable(identifier);
        }
    }
}

