/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.grammar.math;

import java.util.Set;
import java.util.function.BooleanSupplier;
import org.vesalainen.grammar.math.DEH;
import org.vesalainen.grammar.math.DoubleMathStack;
import org.vesalainen.grammar.math.ExpressionHandler;
import org.vesalainen.grammar.math.MathExpressionParserFactory;
import org.vesalainen.grammar.math.MathExpressionParserIntf;
import org.vesalainen.util.NoNeedToContinueException;

public abstract class BooleanMathExpression
extends DoubleMathStack
implements BooleanSupplier {
    private String expression;
    private boolean degrees;
    private DEH stack;

    public BooleanMathExpression(String expression, boolean degrees) {
        this.expression = expression;
        this.degrees = degrees;
    }

    @Override
    public boolean getAsBoolean() {
        if (this.stack == null) {
            this.parse();
        }
        this.clear();
        try {
            this.stack.execute((Object)this);
        }
        catch (NoNeedToContinueException ex) {
            return this.get(0) == 1.0;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return this.pop() == 1.0;
    }

    public Set<String> getVariables() {
        if (this.stack == null) {
            this.parse();
        }
        return this.stack.getVariables();
    }

    private void parse() {
        MathExpressionParserIntf parser = MathExpressionParserFactory.getInstance();
        try {
            this.stack = parser.parseBoolean(this.expression, this.degrees, (ExpressionHandler)this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

