/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.grammar.math;

import java.util.Set;
import java.util.function.DoubleSupplier;
import org.vesalainen.grammar.math.DEH;
import org.vesalainen.grammar.math.DoubleMathStack;
import org.vesalainen.grammar.math.ExpressionHandler;
import org.vesalainen.grammar.math.MathExpressionParserFactory;
import org.vesalainen.grammar.math.MathExpressionParserIntf;

public abstract class DoubleMathExpression
extends DoubleMathStack
implements DoubleSupplier {
    private String expression;
    private boolean degrees;
    private DEH stack;

    public DoubleMathExpression(String expression, boolean degrees) {
        this.expression = expression;
        this.degrees = degrees;
    }

    @Override
    public double getAsDouble() {
        if (this.stack == null) {
            this.parse();
        }
        this.clear();
        try {
            this.stack.execute((Object)this);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return this.pop();
    }

    public Set<String> getVariables() {
        if (this.stack == null) {
            this.parse();
        }
        return this.stack.getVariables();
    }

    private void parse() {
        MathExpressionParserIntf parser = MathExpressionParserFactory.getInstance();
        try {
            this.stack = parser.parse(this.expression, this.degrees, (ExpressionHandler)this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

