/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.grammar.math;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.vesalainen.grammar.math.DEH;
import org.vesalainen.grammar.math.ExpressionHandler;
import org.vesalainen.grammar.math.MathExpressionParserIntf;
import org.vesalainen.parser.ParserFeature;
import org.vesalainen.parser.annotation.GenClassname;
import org.vesalainen.parser.annotation.GrammarDef;
import org.vesalainen.parser.annotation.MathExpression;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.parser.annotation.Terminals;
import org.vesalainen.parser.util.DelayedExecutor;
import org.vesalainen.regex.Regex;

@GenClassname(value="org.vesalainen.grammar.impl.MathExpressionParserImpl")
@GrammarDef
@Terminals(value={@Terminal(left="SQUARE", expression="[\u00b2\u2072]"), @Terminal(left="CUBE", expression="[\u00b3\u2073]"), @Terminal(left="PI", expression="\u03c0"), @Terminal(left="SQRT", expression="\u221a"), @Terminal(left="CBRT", expression="\u2218"), @Terminal(left="PLUS", expression="\\+"), @Terminal(left="MINUS", expression="\\-"), @Terminal(left="STAR", expression="\\*"), @Terminal(left="SLASH", expression="/"), @Terminal(left="PERCENT", expression="%"), @Terminal(left="EXP", expression="\\^"), @Terminal(left="COMMA", expression="\\,"), @Terminal(left="PIPE", expression="\\|"), @Terminal(left="EXCL", expression="!"), @Terminal(left="LBRACKET", expression="\\["), @Terminal(left="RBRACKET", expression="\\]"), @Terminal(left="LPAREN", expression="\\("), @Terminal(left="RPAREN", expression="\\)"), @Terminal(left="AND", expression="&&"), @Terminal(left="OR", expression="\\|\\|"), @Terminal(left="NOT", expression="!"), @Terminal(left="EQ", expression="==?"), @Terminal(left="NE", expression="!="), @Terminal(left="LT", expression="<"), @Terminal(left="LE", expression="<="), @Terminal(left="GT", expression=">"), @Terminal(left="GE", expression=">=")})
public abstract class MathExpressionParser<T, M, F, P>
implements MathExpressionParserIntf<T, M, F, P> {
    public void parse(MathExpression me, ExpressionHandler<T, M, F, P> handler) {
        HashSet<String> variables = new HashSet<String>();
        DEH expression = this.doParse(me.value(), me.degrees(), handler, variables);
        try {
            expression.execute(handler);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public DEH parse(String expression, boolean degrees, ExpressionHandler<T, M, F, P> handler) throws Exception {
        HashSet<String> variables = new HashSet<String>();
        DEH deh = this.doParse(expression, degrees, handler, variables);
        deh.setVariables(variables);
        return deh;
    }

    public DEH parseBoolean(String expression, boolean degrees, ExpressionHandler<T, M, F, P> handler) throws Exception {
        HashSet<String> variables = new HashSet<String>();
        DEH deh = this.doParseBoolean(expression, degrees, handler, variables);
        deh.setVariables(variables);
        return deh;
    }

    @ParseMethod(start="expression", whiteSpace={"whiteSpace", "doubleSlashComment", "hashComment", "cComment"}, features={ParserFeature.SingleThread})
    protected abstract DEH doParse(String var1, @ParserContext(value="degrees") boolean var2, @ParserContext(value="handler") ExpressionHandler<T, M, F, P> var3, @ParserContext(value="variables") Set<String> var4);

    @ParseMethod(start="conditionalExpression", whiteSpace={"whiteSpace", "doubleSlashComment", "hashComment", "cComment"}, features={ParserFeature.SingleThread})
    protected abstract DEH doParseBoolean(String var1, @ParserContext(value="degrees") boolean var2, @ParserContext(value="handler") ExpressionHandler<T, M, F, P> var3, @ParserContext(value="variables") Set<String> var4);

    @Rule(value={"term"})
    protected DEH expression(DEH term) {
        return term;
    }

    @Rule(value={"factor"})
    protected DEH term(DEH factor) {
        return factor;
    }

    @Rule(value={"atom"})
    protected DEH factor(DEH atom) {
        return atom;
    }

    @Rule(value={"LPAREN", "expression", "RPAREN"})
    protected DEH atom(DEH expression) {
        return expression;
    }

    @Rule
    protected List<DEH> expressionList() {
        return new ArrayList<DEH>();
    }

    @Rule(value={"expression"})
    protected List<DEH> expressionList(DEH expression) {
        ArrayList<DEH> list = new ArrayList<DEH>();
        list.add(expression);
        return list;
    }

    @Rule(value={"expressionList", "COMMA", "expression"})
    protected List<DEH> expressionList(List<DEH> list, DEH expression) {
        list.add(expression);
        return list;
    }

    @Rule(left="expression", value={"expression", "PLUS", "term"})
    protected DEH add(DEH expression, DEH term) throws Exception {
        expression.append((DelayedExecutor)term);
        ((ExpressionHandler)expression.getProxy()).add();
        return expression;
    }

    @Rule(left="expression", value={"expression", "MINUS", "term"})
    protected DEH subtract(DEH expression, DEH term) throws Exception {
        expression.append((DelayedExecutor)term);
        ((ExpressionHandler)expression.getProxy()).subtract();
        return expression;
    }

    @Rule(left="term", value={"term", "STAR", "factor"})
    protected DEH mul(DEH term, DEH factor) throws Exception {
        term.append((DelayedExecutor)factor);
        ((ExpressionHandler)term.getProxy()).mul();
        return term;
    }

    @Rule(left="term", value={"term", "SLASH", "factor"})
    protected DEH div(DEH term, DEH factor) throws Exception {
        term.append((DelayedExecutor)factor);
        ((ExpressionHandler)term.getProxy()).div();
        return term;
    }

    @Rule(left="term", value={"term", "PERCENT", "factor"})
    protected DEH mod(DEH term, DEH factor) throws Exception {
        term.append((DelayedExecutor)factor);
        ((ExpressionHandler)term.getProxy()).mod();
        return term;
    }

    @Rule(left="atom", value={"number"})
    protected DEH num(String number) throws Exception {
        DEH atom = new DEH();
        ((ExpressionHandler)atom.getProxy()).number(number);
        return atom;
    }

    @Rule(left="atom", value={"PIPE", "expression", "PIPE"})
    protected DEH abs(DEH expression, @ParserContext(value="degrees") boolean degrees, @ParserContext(value="handler") ExpressionHandler<T, M, F, P> handler) throws Exception {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(expression);
        return this.func("abs", args, degrees, handler);
    }

    @Rule(left="factor", value={"atom", "EXP", "factor"})
    protected DEH power(DEH atom, DEH factor, @ParserContext(value="degrees") boolean degrees, @ParserContext(value="handler") ExpressionHandler<T, M, F, P> handler) throws Exception {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(atom);
        args.add(factor);
        return this.func("pow", args, degrees, handler);
    }

    @Rule(left="atom", value={"atom", "EXCL"})
    protected DEH factorial(DEH atom, @ParserContext(value="degrees") boolean degrees, @ParserContext(value="handler") ExpressionHandler<T, M, F, P> handler) throws Exception {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(atom);
        return this.func("factorial", args, degrees, handler);
    }

    @Rule(left="atom", value={"atom", "SQUARE"})
    protected DEH square(DEH atom) throws Exception {
        ((ExpressionHandler)atom.getProxy()).pow(2);
        return atom;
    }

    @Rule(left="atom", value={"atom", "CUBE"})
    protected DEH cube(DEH atom) throws Exception {
        ((ExpressionHandler)atom.getProxy()).pow(3);
        return atom;
    }

    @Rule(left="factor", value={"SQRT", "atom"})
    protected DEH sqrt(DEH atom, @ParserContext(value="handler") ExpressionHandler<T, M, F, P> handler) throws Exception {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(atom);
        return this.func("sqrt", args, false, handler);
    }

    @Rule(left="factor", value={"CBRT", "atom"})
    protected DEH cbrt(DEH atom, @ParserContext(value="handler") ExpressionHandler<T, M, F, P> handler) throws Exception {
        ArrayList<DEH> args = new ArrayList<DEH>();
        args.add(atom);
        return this.func("cbrt", args, false, handler);
    }

    @Rule(left="atom", value={"PI"})
    protected DEH pi(@ParserContext(value="handler") ExpressionHandler<T, M, F, P> handler) throws Exception {
        DEH atom = new DEH();
        ((ExpressionHandler)atom.getProxy()).loadField(handler.getField(Math.class, "PI"));
        return atom;
    }

    @Rule(left="neg")
    protected boolean none() {
        return false;
    }

    @Rule(left="neg", value={"MINUS"})
    protected boolean minus() {
        return true;
    }

    @Rule
    protected List<DEH> indexList() throws Exception {
        return new ArrayList<DEH>();
    }

    @Rule(value={"indexList", "LBRACKET", "expression", "RBRACKET"})
    protected List<DEH> indexList(List<DEH> list, DEH expression) throws Exception {
        list.add(expression);
        return list;
    }

    @Rule(left="atom", value={"neg", "identifier", "indexList"})
    protected DEH variable(boolean neg, String identifier, List<DEH> indexList, @ParserContext(value="variables") Set<String> variables) throws Exception {
        variables.add(identifier);
        DEH atom = new DEH();
        ExpressionHandler proxy = (ExpressionHandler)atom.getProxy();
        proxy.loadVariable(identifier);
        if (indexList != null && !indexList.isEmpty()) {
            Iterator<DEH> iterator = indexList.iterator();
            while (iterator.hasNext()) {
                DEH expr = iterator.next();
                proxy.setIndex(true);
                atom.append((DelayedExecutor)expr);
                proxy.setIndex(false);
                if (iterator.hasNext()) {
                    proxy.loadArray();
                    continue;
                }
                proxy.loadArrayItem();
            }
        }
        if (neg) {
            proxy.neg();
        }
        return atom;
    }

    @Rule(left="atom", value={"identifier", "LPAREN", "expressionList", "RPAREN"})
    protected DEH func(String identifier, List<DEH> funcArgs, @ParserContext(value="degrees") boolean degrees, @ParserContext(value="handler") ExpressionHandler<T, M, F, P> handler) throws Exception {
        DEH atom = new DEH();
        ExpressionHandler proxy = (ExpressionHandler)atom.getProxy();
        Object method = handler.findMethod(identifier, funcArgs.size());
        List parameters = handler.getParameters(method);
        assert (funcArgs.size() == parameters.size());
        int index = 0;
        for (DEH expr : funcArgs) {
            atom.append((DelayedExecutor)expr);
            proxy.convertTo(handler.asType(parameters.get(index++)));
            if (!degrees || !handler.isRadianArgs(method)) continue;
            proxy.invoke(handler.getMethod(Math.class, "toRadians", new Class[]{Double.TYPE}));
        }
        proxy.invoke(method);
        proxy.convertFrom(handler.getReturnType(method));
        if (degrees && handler.isRadianReturn(method)) {
            proxy.invoke(handler.getMethod(Math.class, "toDegrees", new Class[]{Double.TYPE}));
        }
        return atom;
    }

    @Rule(value={"andExpression"})
    protected DEH conditionalExpression(DEH andExpression) {
        return andExpression;
    }

    @Rule(value={"conditionalExpression", "OR", "andExpression"})
    protected DEH conditionalExpression(DEH conditionalExpression, DEH andExpression) throws Exception {
        ((ExpressionHandler)conditionalExpression.getProxy()).checkOr();
        conditionalExpression.append((DelayedExecutor)andExpression);
        ((ExpressionHandler)conditionalExpression.getProxy()).or();
        return conditionalExpression;
    }

    @Rule(value={"orExpression"})
    protected DEH andExpression(DEH orExpression) {
        return orExpression;
    }

    @Rule(value={"andExpression", "AND", "orExpression"})
    protected DEH andExpression(DEH andExpression, DEH orExpression) throws Exception {
        ((ExpressionHandler)andExpression.getProxy()).checkAnd();
        andExpression.append((DelayedExecutor)orExpression);
        ((ExpressionHandler)andExpression.getProxy()).and();
        return andExpression;
    }

    @Rule(value={"conditionalAtom"})
    protected DEH orExpression(DEH conditionalAtom) {
        return conditionalAtom;
    }

    @Rule(left="conditionalAtom", value={"LPAREN", "conditionalExpression", "RPAREN"})
    protected DEH parenConditional(DEH conditionalExpression) {
        return conditionalExpression;
    }

    @Rule(left="conditionalAtom", value={"NOT", "conditionalAtom"})
    protected DEH notConditional(DEH conditionalExpression) throws Exception {
        ((ExpressionHandler)conditionalExpression.getProxy()).not();
        return conditionalExpression;
    }

    @Rule(left="conditionalAtom", value={"expression", "EQ", "expression"})
    protected DEH eqConditional(DEH exp1, DEH exp2) throws Exception {
        exp1.append((DelayedExecutor)exp2);
        ((ExpressionHandler)exp1.getProxy()).eq();
        return exp1;
    }

    @Rule(left="conditionalAtom", value={"expression", "NE", "expression"})
    protected DEH neConditional(DEH exp1, DEH exp2) throws Exception {
        exp1.append((DelayedExecutor)exp2);
        ((ExpressionHandler)exp1.getProxy()).ne();
        return exp1;
    }

    @Rule(left="conditionalAtom", value={"expression", "LT", "expression"})
    protected DEH ltConditional(DEH exp1, DEH exp2) throws Exception {
        exp1.append((DelayedExecutor)exp2);
        ((ExpressionHandler)exp1.getProxy()).lt();
        return exp1;
    }

    @Rule(left="conditionalAtom", value={"expression", "LE", "expression"})
    protected DEH leConditional(DEH exp1, DEH exp2) throws Exception {
        exp1.append((DelayedExecutor)exp2);
        ((ExpressionHandler)exp1.getProxy()).le();
        return exp1;
    }

    @Rule(left="conditionalAtom", value={"expression", "GT", "expression"})
    protected DEH gtConditional(DEH exp1, DEH exp2) throws Exception {
        exp1.append((DelayedExecutor)exp2);
        ((ExpressionHandler)exp1.getProxy()).gt();
        return exp1;
    }

    @Rule(left="conditionalAtom", value={"expression", "GE", "expression"})
    protected DEH geConditional(DEH exp1, DEH exp2) throws Exception {
        exp1.append((DelayedExecutor)exp2);
        ((ExpressionHandler)exp1.getProxy()).ge();
        return exp1;
    }

    @Terminal(expression="[a-zA-Z\\$_][a-zA-Z0-9\\$_]*")
    protected abstract String identifier(String var1);

    @Terminal(expression="(0x|0b)?[\\+\\-]?[0-9]+")
    protected abstract String integer(String var1);

    @Terminal(expression="(0x|0b)?[\\+\\-]?[0-9]+(\\.[0-9]+)?([eE][\\+\\-]?[0-9]+)?")
    protected abstract String number(String var1);

    @Terminal(expression="[ \t\r\n]+")
    protected abstract void whiteSpace();

    @Terminal(expression="\\-\\-[^\n]*\n")
    protected abstract void doubleSlashComment();

    @Terminal(expression="#[^\n]*\n")
    protected abstract void hashComment();

    @Terminal(expression="/\\*.*\\*/", options={Regex.Option.FIXED_ENDER})
    protected abstract void cComment();
}

