/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.date;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.lang.model.element.ExecutableElement;
import org.vesalainen.bcc.model.El;
import org.vesalainen.grammar.Grammar;
import org.vesalainen.parser.GenClassFactory;
import org.vesalainen.parser.annotation.GenClassname;
import org.vesalainen.parser.annotation.GrammarDef;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.parsers.date.DateReducers;
import org.vesalainen.regex.Regex;

@GenClassname(value="org.vesalainen.parsers.date.DateFormatParserImpl")
@GrammarDef
public abstract class DateFormatParser {
    public static DateFormatParser newInstance(Class<?> superClass) {
        DateFormatParser dfg = (DateFormatParser)GenClassFactory.getGenInstance(DateFormatParser.class);
        return dfg;
    }

    @ParseMethod(start="rhs")
    public abstract List<String> parse(String var1, @ParserContext(value="GRAMMAR") Grammar var2, @ParserContext(value="LOCALE") Locale var3, @ParserContext(value="SYMBOLS") DateFormatSymbols var4, @ParserContext(value="ERA") ExecutableElement[] var5, @ParserContext(value="MONTH") ExecutableElement[] var6, @ParserContext(value="WEEKDAY") ExecutableElement[] var7, @ParserContext(value="AMPM") ExecutableElement[] var8) throws IOException;

    @Rule
    protected List<String> rhs() {
        return new ArrayList<String>();
    }

    @Rules(value={@Rule(value={"rhs", "literal"}), @Rule(value={"rhs", "delimiter"})})
    protected List<String> rhs(List<String> rhs, String literal, @ParserContext(value="GRAMMAR") Grammar grammar) {
        rhs.add(Regex.escape((String)literal));
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tG"})
    protected List<String> era(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar, @ParserContext(value="SYMBOLS") DateFormatSymbols symbols, @ParserContext(value="ERA") ExecutableElement[] era) {
        if (!grammar.hasNonterminal(name)) {
            DateFormatParser.addRules(grammar, name, symbols.getEras(), era);
            rhs.add(name);
        } else {
            rhs.add(name);
        }
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "ty"})
    protected List<String> year(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            int len = name.length();
            if (len == 2) {
                grammar.addRule(name, new String[]{"year2"});
            } else {
                grammar.addRule(name, new String[]{"year4"});
            }
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tM"})
    protected List<String> month(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar, @ParserContext(value="SYMBOLS") DateFormatSymbols symbols, @ParserContext(value="MONTH") ExecutableElement[] month) throws NoSuchMethodException {
        int len = name.length();
        if (!grammar.hasNonterminal(name = len >= 3 ? "MMM" : "MM")) {
            if (len >= 3) {
                DateFormatParser.addRules(grammar, name, symbols.getShortMonths(), symbols.getMonths(), month);
            } else {
                grammar.addRule(name, new String[]{"month"});
            }
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tw"})
    protected List<String> weekInYear(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"weekInYear"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tW"})
    protected List<String> weekInMonth(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"weekInMonth"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tD"})
    protected List<String> dayInYear(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"dayInYear"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "td"})
    protected List<String> dayInMonth(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"dayInMonth"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tF"})
    protected List<String> dayOfWeekInMonth(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"dayInWeekInMonth"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tE"})
    protected List<String> dayInWeek(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar, @ParserContext(value="SYMBOLS") DateFormatSymbols symbols, @ParserContext(value="WEEKDAY") ExecutableElement[] weekday) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            DateFormatParser.addRules(grammar, name, symbols.getShortWeekdays(), symbols.getWeekdays(), weekday);
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "ta"})
    protected List<String> ampm(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar, @ParserContext(value="SYMBOLS") DateFormatSymbols symbols, @ParserContext(value="AMPM") ExecutableElement[] ampm) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            DateFormatParser.addRules(grammar, name, symbols.getAmPmStrings(), ampm);
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tH"})
    protected List<String> hour23(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"hour23"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tk"})
    protected List<String> hour24(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"hour24"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tK"})
    protected List<String> hour11(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"hour11"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "th"})
    protected List<String> hour12(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"hour12"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tm"})
    protected List<String> minute(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"minute"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "ts"})
    protected List<String> second(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"second"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tS"})
    protected List<String> millis(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!"SSS".equals(name)) {
            throw new IllegalArgumentException(name + " for milliseconds illegal");
        }
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"milliSecond"});
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tz"})
    protected List<String> generalTZ(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            this.createTZRules(name, grammar);
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tX"})
    protected List<String> iso8601(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        if (!grammar.hasNonterminal(name)) {
            switch (name) {
                case "X": {
                    grammar.addRule(name, new String[]{"iso8601OneDigit"});
                    break;
                }
                case "XX": {
                    grammar.addRule(name, new String[]{"iso8601TwoDigit"});
                    break;
                }
                case "XXX": {
                    grammar.addRule(name, new String[]{"iso8601ThreeDigit"});
                    break;
                }
                default: {
                    throw new IllegalArgumentException(name + " illegal tz");
                }
            }
        }
        rhs.add(name);
        return rhs;
    }

    @Rule(left="rhs", value={"rhs", "tZ"})
    protected List<String> rfc822TZ(List<String> rhs, String name, @ParserContext(value="GRAMMAR") Grammar grammar) throws NoSuchMethodException {
        return this.timezone(rhs, grammar);
    }

    private List<String> timezone(List<String> rhs, Grammar grammar) throws NoSuchMethodException {
        String name = "Z";
        if (!grammar.hasNonterminal(name)) {
            grammar.addRule(name, new String[]{"rfc822"});
        }
        rhs.add(name);
        return rhs;
    }

    @Terminal(expression="'[^']*'")
    protected String literal(String text, @ParserContext(value="GRAMMAR") Grammar grammar) {
        return text;
    }

    @Terminal(expression="[^A-Za-z']+")
    protected String delimiter(String text) {
        return "'" + text + "'";
    }

    @Terminal(expression="G+")
    protected String tG(String text) {
        return text;
    }

    @Terminal(expression="y+")
    protected String ty(String text) {
        return text;
    }

    @Terminal(expression="M+")
    protected String tM(String text) {
        return text;
    }

    @Terminal(expression="w+")
    protected String tw(String text) {
        return text;
    }

    @Terminal(expression="W+")
    protected String tW(String text) {
        return text;
    }

    @Terminal(expression="D+")
    protected String tD(String text) {
        return text;
    }

    @Terminal(expression="d+")
    protected String td(String text) {
        return text;
    }

    @Terminal(expression="F+")
    protected String tF(String text) {
        return text;
    }

    @Terminal(expression="E+")
    protected String tE(String text) {
        return text;
    }

    @Terminal(expression="a+")
    protected String ta(String text) {
        return text;
    }

    @Terminal(expression="H+")
    protected String tH(String text) {
        return text;
    }

    @Terminal(expression="k+")
    protected String tk(String text) {
        return text;
    }

    @Terminal(expression="K+")
    protected String tK(String text) {
        return text;
    }

    @Terminal(expression="h+")
    protected String th(String text) {
        return text;
    }

    @Terminal(expression="m+")
    protected String tm(String text) {
        return text;
    }

    @Terminal(expression="s+")
    protected String ts(String text) {
        return text;
    }

    @Terminal(expression="S+")
    protected String tS(String text) {
        return text;
    }

    @Terminal(expression="z+")
    protected String tz(String text) {
        return text;
    }

    @Terminal(expression="Z+")
    protected String tZ(String text) {
        return text;
    }

    @Terminal(expression="X+")
    protected String tX(String text) {
        return text;
    }

    private static void addRules(Grammar grammar, String nt, String[] choice, ExecutableElement[] reducer) {
        int c = choice[0].isEmpty() ? 1 : 0;
        for (int ii = 0; ii < reducer.length; ++ii) {
            grammar.addRule(reducer[ii], nt, new String[]{"'" + Regex.escape((String)choice[c]) + "'"});
            ++c;
        }
    }

    private static void addRules(Grammar grammar, String nt, String[] shortChoice, String[] longChoice, ExecutableElement[] reducer) {
        int c = shortChoice[0].isEmpty() ? 1 : 0;
        for (int ii = 0; ii < reducer.length; ++ii) {
            String expr;
            if (longChoice[c].startsWith(shortChoice[c])) {
                expr = DateFormatParser.makeSuffixOptional(longChoice[c], shortChoice[c].length());
                grammar.addRule(reducer[ii], nt, new String[]{"'" + expr + "'"});
            } else {
                expr = Regex.escape((String)longChoice[c]);
                grammar.addRule(reducer[ii], nt, new String[]{"'" + expr + "'"});
                expr = Regex.escape((String)shortChoice[c]);
                grammar.addRule(reducer[ii], nt, new String[]{"'" + expr + "'"});
            }
            ++c;
        }
    }

    private static String makeSuffixOptional(String s, int prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(Regex.escape((String)s.substring(0, prefix)));
        for (int ii = prefix; ii < s.length(); ++ii) {
            sb.append("|");
            sb.append(Regex.escape((String)s.substring(0, ii + 1)));
        }
        return sb.toString();
    }

    private void createTZRules(String name, Grammar grammar) {
        grammar.addRule("z", new String[]{"generalTZ"});
        HashMap<Integer, StringBuilder> map = new HashMap<Integer, StringBuilder>();
        HashSet<String> set = new HashSet<String>();
        for (String id : TimeZone.getAvailableIDs()) {
            TimeZone tz = TimeZone.getTimeZone(id);
            int offset = tz.getRawOffset();
            StringBuilder sb = (StringBuilder)map.get(offset);
            if (sb == null) {
                sb = new StringBuilder();
                map.put(offset, sb);
            }
            this.appendTZ(set, sb, id);
            id = tz.getDisplayName(false, 0);
            this.appendTZ(set, sb, id);
            id = tz.getDisplayName(false, 1);
            this.appendTZ(set, sb, id);
            int dst = tz.getDSTSavings();
            offset = dst == 0 || dst == 3600000 ? (offset += 3600000) : (offset += dst);
            sb = (StringBuilder)map.get(offset);
            if (sb == null) {
                sb = new StringBuilder();
                map.put(offset, sb);
            }
            id = tz.getDisplayName(true, 0);
            this.appendTZ(set, sb, id);
            id = tz.getDisplayName(true, 1);
            this.appendTZ(set, sb, id);
        }
        block6: for (char mtz = 'A'; mtz <= 'Z'; mtz = (char)((char)(mtz + 1))) {
            switch (mtz) {
                case 'Z': {
                    this.addMTZ(map, set, mtz, 0);
                    continue block6;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': {
                    this.addMTZ(map, set, mtz, mtz - 65 + 1);
                    continue block6;
                }
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': {
                    this.addMTZ(map, set, mtz, -(mtz - 78 + 1));
                }
            }
        }
        Iterator i$ = map.keySet().iterator();
        while (i$.hasNext()) {
            int offset = (Integer)i$.next();
            String methodName = "tzOffset" + offset;
            methodName = methodName.replace('-', '_');
            StringBuilder sb = (StringBuilder)map.get(offset);
            if (sb.length() <= 0) continue;
            grammar.addRule(El.getMethod(DateReducers.class, (String)"generalTZ", (Class[])new Class[]{Integer.TYPE, Calendar.class}), "generalTZ", new String[]{methodName});
            System.err.println("@Terminal(expression=\"" + sb.toString().replace("\\", "\\\\") + "\")");
            System.err.println("protected int " + methodName + "() { return " + offset + ";}");
        }
    }

    private void addMTZ(Map<Integer, StringBuilder> map, Set<String> set, char mtz, int hours) {
        int offset = hours * 60 * 60 * 1000;
        StringBuilder sb = map.get(offset);
        this.appendTZ(set, sb, String.valueOf(mtz));
    }

    private void appendTZ(Set<String> set, StringBuilder sb, String id) {
        if (!set.contains(id) && (id.equals("GMT") || id.equals("GMT0") || !id.startsWith("GMT"))) {
            set.add(id);
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(Regex.escape((String)id));
        }
    }
}

