/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.date;

import java.util.Calendar;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;

public abstract class DateReducers {
    protected void ad(@ParserContext Calendar cal) {
        cal.set(0, 0);
    }

    protected void bc(@ParserContext Calendar cal) {
        cal.set(0, 1);
    }

    @Rule(value={"digit12"})
    protected void year2(int y, @ParserContext Calendar cal) {
        if (y > 70) {
            cal.set(1, 1900 + y);
        } else {
            cal.set(1, 2000 + y);
        }
    }

    @Terminal(expression="[0-9]{4}")
    protected void year4(int y, @ParserContext Calendar cal) {
        cal.set(1, y);
    }

    @Rule(value={"digit12"})
    protected void month(int m, @ParserContext Calendar cal) {
        cal.set(2, m - 1);
    }

    protected void month1(@ParserContext Calendar cal) {
        cal.set(2, 0);
    }

    protected void month2(@ParserContext Calendar cal) {
        cal.set(2, 1);
    }

    protected void month3(@ParserContext Calendar cal) {
        cal.set(2, 2);
    }

    protected void month4(@ParserContext Calendar cal) {
        cal.set(2, 3);
    }

    protected void month5(@ParserContext Calendar cal) {
        cal.set(2, 4);
    }

    protected void month6(@ParserContext Calendar cal) {
        cal.set(2, 5);
    }

    protected void month7(@ParserContext Calendar cal) {
        cal.set(2, 6);
    }

    protected void month8(@ParserContext Calendar cal) {
        cal.set(2, 7);
    }

    protected void month9(@ParserContext Calendar cal) {
        cal.set(2, 8);
    }

    protected void month10(@ParserContext Calendar cal) {
        cal.set(2, 9);
    }

    protected void month11(@ParserContext Calendar cal) {
        cal.set(2, 10);
    }

    protected void month12(@ParserContext Calendar cal) {
        cal.set(2, 11);
    }

    @Rule(value={"digit13"})
    protected void weekInYear(int w, @ParserContext Calendar cal) {
        cal.set(3, w);
    }

    @Rule(value={"digit1"})
    protected void weekInMonth(int w, @ParserContext Calendar cal) {
        cal.set(4, w);
    }

    @Rule(value={"digit13"})
    protected void dayInYear(int d, @ParserContext Calendar cal) {
        cal.set(6, d);
    }

    @Rule(value={"digit12"})
    protected void dayInMonth(int d, @ParserContext Calendar cal) {
        cal.set(5, d);
    }

    @Rule(value={"digit1"})
    protected void dayInWeekInMonth(int d, @ParserContext Calendar cal) {
        cal.set(8, d);
    }

    protected void weekday1(@ParserContext Calendar cal) {
        cal.set(7, 1);
    }

    protected void weekday2(@ParserContext Calendar cal) {
        cal.set(7, 2);
    }

    protected void weekday3(@ParserContext Calendar cal) {
        cal.set(7, 3);
    }

    protected void weekday4(@ParserContext Calendar cal) {
        cal.set(7, 4);
    }

    protected void weekday5(@ParserContext Calendar cal) {
        cal.set(7, 5);
    }

    protected void weekday6(@ParserContext Calendar cal) {
        cal.set(7, 6);
    }

    protected void weekday7(@ParserContext Calendar cal) {
        cal.set(7, 7);
    }

    protected void am(@ParserContext Calendar cal) {
        cal.set(9, 0);
    }

    protected void pm(@ParserContext Calendar cal) {
        cal.set(9, 1);
    }

    @Rule(value={"digit12"})
    protected void hour23(int h, @ParserContext Calendar cal) {
        cal.set(11, h);
    }

    @Rule(value={"digit12"})
    protected void hour24(int h, @ParserContext Calendar cal) {
        cal.set(11, h + 1);
    }

    @Rule(value={"digit12"})
    protected void hour11(int h, @ParserContext Calendar cal) {
        cal.set(10, h);
    }

    @Rule(value={"digit12"})
    protected void hour12(int h, @ParserContext Calendar cal) {
        cal.set(10, h + 1);
    }

    @Rule(value={"digit12"})
    protected void minute(int m, @ParserContext Calendar cal) {
        cal.set(12, m);
    }

    @Rule(value={"digit12"})
    protected void second(int s, @ParserContext Calendar cal) {
        cal.set(13, s);
    }

    @Rule(value={"digit3"})
    protected void milliSecond(int m, @ParserContext Calendar cal) {
        cal.set(14, m);
    }

    protected void generalTZ(int offset, @ParserContext Calendar cal) {
        cal.set(15, offset);
    }

    @Terminal(expression="GMT[\\+\\-][0-9]{2}:[0-9]{2}")
    protected int rfc822String1(String s) {
        char sign = s.charAt(3);
        int h = Integer.parseInt(s.substring(4, 6));
        int m = Integer.parseInt(s.substring(7, 9));
        if (sign == '+') {
            return h * 3600000 + m * 60000;
        }
        return -(h * 3600000 + m * 60000);
    }

    @Terminal(expression="GMT[\\+\\-][0-9]{2}[0-9]{2}")
    protected int rfc822String2(String s) {
        char sign = s.charAt(3);
        int h = Integer.parseInt(s.substring(4, 6));
        int m = Integer.parseInt(s.substring(6, 8));
        if (sign == '+') {
            return h * 3600000 + m * 60000;
        }
        return -(h * 3600000 + m * 60000);
    }

    @Terminal(expression="[\\+\\-][0-9]{2}:[0-9]{2}")
    protected int rfc822String3(String s) {
        char sign = s.charAt(0);
        int h = Integer.parseInt(s.substring(1, 3));
        int m = Integer.parseInt(s.substring(4, 6));
        if (sign == '+') {
            return h * 3600000 + m * 60000;
        }
        return -(h * 3600000 + m * 60000);
    }

    @Terminal(expression="[\\+\\-][0-9]{2}[0-9]{2}")
    protected int rfc822String4(String s) {
        char sign = s.charAt(0);
        int h = Integer.parseInt(s.substring(1, 3));
        int m = Integer.parseInt(s.substring(3, 5));
        if (sign == '+') {
            return h * 3600000 + m * 60000;
        }
        return -(h * 3600000 + m * 60000);
    }

    @Rules(value={@Rule(value={"rfc822String1"}), @Rule(value={"rfc822String2"}), @Rule(value={"rfc822String3"}), @Rule(value={"rfc822String4"})})
    protected void rfc822(int offset, @ParserContext Calendar cal) {
        cal.set(15, offset);
    }

    @Terminal(expression="[a-zA-Z]")
    protected char character(char d) {
        return d;
    }

    @Terminal(expression="[\\+\\-]")
    protected char sign(char d) {
        return d;
    }

    @Terminal(expression="[0-9]{1,3}")
    protected int digit13(int d) {
        return d;
    }

    @Terminal(expression="[0-9]{3}")
    protected int digit3(int d) {
        return d;
    }

    @Terminal(expression="[0-9]{2}")
    protected int digit2(int d) {
        return d;
    }

    @Terminal(expression="[0-9]{1,2}")
    protected int digit12(int d) {
        return d;
    }

    protected String string(String s) {
        return s;
    }
}

