/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.date;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.vesalainen.parsers.date.LocaleDateParser;
import org.vesalainen.parsers.date.SimpleDateGrammar;

public class LocaleDateGrammar
extends SimpleDateGrammar {
    public LocaleDateGrammar() throws UnsupportedOperationException, IOException {
        this(Locale.getDefault(), DateFormatSymbols.getInstance());
    }

    public LocaleDateGrammar(Locale locale) throws UnsupportedOperationException, IOException {
        this(locale, DateFormatSymbols.getInstance(locale));
    }

    public LocaleDateGrammar(Locale locale, DateFormatSymbols symbols) throws UnsupportedOperationException, IOException {
        super(locale, symbols, LocaleDateParser.class);
        this.locale = locale;
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, locale);
        this.addPattern("dateTime", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1, locale);
        this.addPattern("dateTime", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, locale);
        this.addPattern("dateTime", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale);
        this.addPattern("dateTime", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getDateInstance(0, locale);
        this.addPattern("date", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getDateInstance(1, locale);
        this.addPattern("date", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
        this.addPattern("date", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        this.addPattern("date", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getTimeInstance(0, locale);
        this.addPattern("time", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getTimeInstance(1, locale);
        this.addPattern("time", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getTimeInstance(2, locale);
        this.addPattern("time", df.toPattern());
        df = (SimpleDateFormat)DateFormat.getTimeInstance(3, locale);
        this.addPattern("time", df.toPattern());
    }

    public static void main(String[] args) {
        try {
            LocaleDateGrammar g = new LocaleDateGrammar();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

