/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.http;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vesalainen.parser.annotation.GenClassname;
import org.vesalainen.parser.annotation.GrammarDef;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.parser.annotation.Terminals;

@GenClassname(value="org.vesalainen.parsers.http.InternetHeaderParserImpl")
@GrammarDef
@Terminals(value={@Terminal(left="COLON", expression="[ \t]*:[ \t]*"), @Terminal(left="CRLF", expression="\r\n"), @Terminal(left="LWS", expression="\r[ \t]+")})
public abstract class InternetHeaderParser {
    public Map<String, List<String>> parse(String str) {
        HashMap<String, List<String>> hdr = new HashMap<String, List<String>>();
        this.parse(str, hdr);
        return hdr;
    }

    public Map<String, List<String>> parse(InputStream is) {
        HashMap<String, List<String>> hdr = new HashMap<String, List<String>>();
        this.parse(is, hdr);
        return hdr;
    }

    @ParseMethod(start="messageHeader", size=80)
    protected abstract Map<String, List<String>> parse(String var1, @ParserContext Map<String, List<String>> var2);

    @ParseMethod(start="messageHeader", size=80)
    protected abstract Map<String, List<String>> parse(InputStream var1, @ParserContext Map<String, List<String>> var2);

    @Rule(value={"messageHeaders", "CRLF"})
    protected void messageHeader(@ParserContext Map<String, List<String>> hdr) {
    }

    @Rule
    protected void messageHeaders() {
    }

    @Rule(value={"messageHeaders", "fieldName", "COLON", "fieldValue", "CRLF"})
    protected void messageHeaders(String fieldName, String fieldValue, @ParserContext Map<String, List<String>> hdr) {
        List<String> list = hdr.get(fieldName);
        if (list == null) {
            list = new ArrayList<String>();
            hdr.put(fieldName, list);
        }
        list.add(fieldValue);
    }

    @Terminal(expression="[^\\x00-\\x20\\(\\)<>@\\,;:\\\\\"/\\[\\]\\?=\\{\\}\t]+")
    protected abstract String fieldName(String var1);

    @Terminal(expression="[^\r\n]+")
    protected abstract String line(String var1);

    @Rule(value={"line"})
    protected String fieldValue(String s1) {
        return s1;
    }

    @Rule(value={"line", "LWS", "fieldValue"})
    protected String fieldValue(String s1, String s2) {
        return s1 + " " + s2;
    }
}

