/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.Condition;
import org.vesalainen.parsers.sql.ParserLocator2Impl;
import org.vesalainen.parsers.sql.Relation;
import org.vesalainen.parsers.sql.SQLConverter;

public abstract class BaseComparison<R, C>
extends ParserLocator2Impl
implements Condition<R, C> {
    protected ColumnReference<R, C> columnReference;
    protected Relation relation;

    public BaseComparison(ColumnReference<R, C> columnReference, Relation relation) {
        this.columnReference = columnReference;
        this.relation = relation;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public boolean matches(SQLConverter<R, C> selector, C col1, C col2) {
        int cmp = selector.getComparator().compare(col1, col2);
        return BaseComparison.matches(cmp, this.relation);
    }

    public static boolean matches(int cmp, Relation relation) {
        switch (relation) {
            case EQ: {
                return cmp == 0;
            }
            case NE: {
                return cmp != 0;
            }
            case LT: {
                return cmp < 0;
            }
            case GT: {
                return cmp > 0;
            }
            case LE: {
                return cmp <= 0;
            }
            case GE: {
                return cmp >= 0;
            }
        }
        throw new UnsupportedOperationException("unknown relation " + (Object)((Object)relation));
    }

    public String getColumn() {
        return this.columnReference.getColumn();
    }

    public ColumnReference<R, C> getColumnReference() {
        return this.columnReference;
    }
}

