/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.LinkedHashMap;
import java.util.List;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.FetchResult;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.Statement;

public class BatchStatement<R, C>
extends Statement<R, C> {
    private List<Statement<R, C>> statementList;

    public BatchStatement(Engine engine, LinkedHashMap placeholderMap, List<Statement<R, C>> list) {
        super(engine, placeholderMap);
        this.statementList = list;
    }

    @Override
    public FetchResult execute() {
        if (this.statementList.size() == 1) {
            return this.statementList.get(0).execute();
        }
        for (Statement<R, C> statement : this.statementList) {
            statement.execute();
        }
        return null;
    }

    @Override
    public boolean isSelectStatement() {
        if (this.statementList.size() == 1) {
            return this.statementList.get(0) instanceof SelectStatement;
        }
        return false;
    }

    public List<Statement<R, C>> getStatementList() {
        return this.statementList;
    }
}

