/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.vesalainen.parsers.sql.ColumnCondition;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.Condition;
import org.vesalainen.parsers.sql.ParserLocator2Impl;
import org.vesalainen.parsers.sql.SQLConverter;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.util.ArrayMap;

public class ColumnReferenceImpl<R, C>
extends ParserLocator2Impl
implements ColumnReference<R, C> {
    protected Table<R, C> table;
    protected String tablePart;
    protected String column;
    protected List<String> raw;
    private String title;

    public ColumnReferenceImpl(List<String> raw) {
        this.raw = raw;
    }

    public ColumnReferenceImpl(List<String> raw, String title) {
        this.raw = raw;
        this.title = title;
    }

    ColumnReferenceImpl(Table<R, C> table, String name) {
        this.table = table;
        this.tablePart = table.getName();
        this.column = name;
        this.title = name;
    }

    @Override
    public boolean resolvTable(Collection<Table<R, C>> tables) {
        for (Table<R, C> table : tables) {
            if (this.table != null) {
                return true;
            }
            String first = this.raw.get(0);
            if (first.equals(table.getCorrelationName())) {
                this.table = table;
                this.tablePart = first;
                this.setColumn(this.toString(this.raw.subList(1, this.raw.size())));
                this.raw = null;
                return true;
            }
            if (first.equals(table.getSchema())) {
                this.table = table;
                this.tablePart = this.toString(this.raw.subList(1, 2));
                this.setColumn(this.toString(this.raw.subList(2, this.raw.size())));
                this.raw = null;
                return true;
            }
            if (!first.equals(table.getName())) continue;
            this.table = table;
            this.tablePart = first;
            this.setColumn(this.toString(this.raw.subList(1, this.raw.size())));
            this.raw = null;
            return true;
        }
        if (tables.size() == 1 && this.raw.size() == 1) {
            this.table = tables.iterator().next();
            this.tablePart = this.table.getName();
            this.setColumn(this.raw.get(0));
            this.raw = null;
            return true;
        }
        this.throwException("table not found");
        return false;
    }

    private void setColumn(String column) {
        this.column = column;
        if (this.title == null) {
            this.title = column;
        }
    }

    private String toString(List<String> sub) {
        StringBuilder sb = new StringBuilder();
        for (String str : sub) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @Override
    public Table<R, C> getTable() {
        return this.table;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public String getCorrelation() {
        return this.tablePart;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnReferenceImpl other = (ColumnReferenceImpl)obj;
        if (!Objects.equals(this.tablePart, other.tablePart)) {
            return false;
        }
        return Objects.equals(this.column, other.column);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.tablePart);
        hash = 67 * hash + Objects.hashCode(this.column);
        return hash;
    }

    @Override
    public void associateCondition(Condition<R, C> condition, boolean andPath) {
        if (condition instanceof ColumnCondition) {
            ColumnCondition tc = (ColumnCondition)condition;
            this.table.associateCondition(tc, andPath);
        }
    }

    @Override
    public C getValue(SQLConverter<R, C> selector, R row) {
        assert (row != null);
        return selector.get(row, this.column);
    }

    @Override
    public C getValue(SQLConverter<R, C> selector, ArrayMap<Table<R, C>, R> rowCandidate) {
        assert (rowCandidate != null);
        R row = rowCandidate.get(this.table);
        if (row != null) {
            return selector.get(row, this.column);
        }
        return null;
    }

    public String toString() {
        if (this.tablePart != null) {
            return this.tablePart + "." + this.column;
        }
        return this.column;
    }

    @Override
    public void setTable(Table<R, C> table) {
        this.table = table;
    }

    @Override
    public int getEnd() {
        int start = this.getStart();
        if (this.tablePart != null) {
            return start + this.tablePart.length() + 1 + this.column.length();
        }
        return start + this.column.length();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }
}

