/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.math.BigInteger;
import java.util.Arrays;
import org.vesalainen.parsers.sql.AbstractFunction;
import org.vesalainen.parsers.sql.ColumnReference;

public class CreditorReferenceFunction
extends AbstractFunction {
    private static final char[] mask = new char[]{'7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7'};

    public CreditorReferenceFunction(ColumnReference inner) {
        super(inner);
    }

    @Override
    public Object function(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String str = (String)value;
            CreditorReference vn = new CreditorReference(str, false);
            return vn.toFormattedRFString();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            CreditorReference vn = new CreditorReference(number.longValue(), false);
            return vn.toFormattedRFString();
        }
        throw new IllegalArgumentException("creditorreference cannot process type " + value.getClass());
    }

    public static String create(String prefix, String code) {
        BigInteger bbban = new BigInteger(code);
        StringBuilder sb = new StringBuilder();
        sb.append(code);
        for (char cc : prefix.toCharArray()) {
            int k = cc - 65 + 10;
            sb.append(k);
        }
        sb.append("00");
        BigInteger bi = new BigInteger(sb.toString());
        BigInteger remainder = bi.remainder(new BigInteger("97"));
        int cd = 98 - remainder.intValue();
        return String.format("%s%02d%d", prefix, cd, bbban);
    }

    public static void check(String str) {
        String code = str.replace(" ", "");
        String bbanString = code.substring(4);
        String prefix = code.substring(0, 2);
        String iban = CreditorReferenceFunction.create(prefix, bbanString);
        if (!code.equals(iban)) {
            throw new IllegalArgumentException(str + " illegal format");
        }
    }

    public static String format(String code) {
        CreditorReferenceFunction.check(code);
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < code.length(); ii += 4) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(code.substring(ii, Math.min(ii + 4, code.length())));
        }
        return sb.toString();
    }

    public class CreditorReference {
        private char[] buffer = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

        public CreditorReference(String str, boolean check) {
            str = str.replace(" ", "");
            if (str.startsWith("RF")) {
                str = str.substring(4);
                str.getChars(0, str.length(), this.buffer, this.buffer.length - str.length());
            } else {
                if (check ? str.length() > this.buffer.length : str.length() > this.buffer.length - 1) {
                    throw new IllegalArgumentException(str + " is too long");
                }
                for (int ii = 0; ii < str.length(); ++ii) {
                    if (str.charAt(ii) >= '0' && str.charAt(ii) <= '9') continue;
                    throw new IllegalArgumentException(str + " contains non numeric characters");
                }
                if (check) {
                    str.getChars(0, str.length(), this.buffer, this.buffer.length - str.length());
                } else {
                    str.getChars(0, str.length(), this.buffer, this.buffer.length - 1 - str.length());
                }
                this.calcCheckDigit(check);
            }
        }

        public CreditorReference(long n, boolean check) {
            String str = String.valueOf(n);
            if (check) {
                str.getChars(0, str.length(), this.buffer, this.buffer.length - str.length());
            } else {
                str.getChars(0, str.length(), this.buffer, this.buffer.length - 1 - str.length());
            }
            this.calcCheckDigit(check);
        }

        private void calcCheckDigit(boolean check) {
            int chk = 0;
            for (int ii = 0; ii < this.buffer.length - 1; ++ii) {
                chk += (mask[ii] - 48) * (this.buffer[ii] - 48);
            }
            if (check) {
                if (this.buffer[this.buffer.length - 1] != (char)(48 + (char)((10 - chk % 10) % 10))) {
                    throw new IllegalArgumentException(this + " has wrong check digit");
                }
            } else {
                this.buffer[this.buffer.length - 1] = (char)(48 + (char)((10 - chk % 10) % 10));
            }
        }

        public String toBankingBarcodeString() {
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < this.buffer.length; ++ii) {
                sb.append(this.buffer[ii]);
            }
            return sb.toString();
        }

        public String toRFString() {
            return CreditorReferenceFunction.create("RF", new String(this.buffer));
        }

        public String toFormattedRFString() {
            return CreditorReferenceFunction.format(CreditorReferenceFunction.create("RF", new String(this.buffer)));
        }

        public String toString() {
            boolean startzero = true;
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < this.buffer.length; ++ii) {
                if (startzero) {
                    if (this.buffer[ii] == '0') continue;
                    sb.append(this.buffer[ii]);
                    startzero = false;
                    continue;
                }
                if (ii % 5 == 0) {
                    sb.append(' ');
                }
                sb.append(this.buffer[ii]);
            }
            return sb.toString();
        }

        public int fill(char version, int start, char[] buf) {
            switch (version) {
                case '2': 
                case '4': {
                    for (int ii = 0; ii < this.buffer.length; ++ii) {
                        buf[start + ii] = this.buffer[ii];
                    }
                    return start + this.buffer.length;
                }
                case '5': {
                    Arrays.fill(buf, start, start + 23, '0');
                    String rfRef = this.toRFString();
                    char[] cb = rfRef.substring(2, 4).toCharArray();
                    for (int ii = 0; ii < 2; ++ii) {
                        buf[start + ii] = cb[ii];
                    }
                    cb = rfRef.substring(4).toCharArray();
                    int fillen = 23 - cb.length;
                    for (int ii = 0; ii < cb.length; ++ii) {
                        buf[start + fillen + ii] = cb[ii];
                    }
                    return start + 23;
                }
            }
            throw new IllegalArgumentException("wrong version " + version);
        }
    }
}

