/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.vesalainen.parser.GenClassFactory;
import org.vesalainen.parser.util.InputReader;
import org.vesalainen.parsers.sql.AbstractFunction;
import org.vesalainen.parsers.sql.ColumnMetadata;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.Condition;
import org.vesalainen.parsers.sql.CreditorReferenceFunction;
import org.vesalainen.parsers.sql.ExtractFunction;
import org.vesalainen.parsers.sql.FetchResult;
import org.vesalainen.parsers.sql.FormatFunction;
import org.vesalainen.parsers.sql.InsertStatement;
import org.vesalainen.parsers.sql.Metadata;
import org.vesalainen.parsers.sql.OrderedFetchResult;
import org.vesalainen.parsers.sql.Placeholder;
import org.vesalainen.parsers.sql.SQLConverter;
import org.vesalainen.parsers.sql.SQLLocator;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.SqlParser;
import org.vesalainen.parsers.sql.Statement;
import org.vesalainen.parsers.sql.SubStringFunction;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TableContext;
import org.vesalainen.parsers.sql.TableContextComparator;
import org.vesalainen.parsers.sql.TableMetadata;
import org.vesalainen.parsers.sql.ToDateFunction;
import org.vesalainen.parsers.sql.ToFunction;
import org.vesalainen.parsers.sql.ToStringFunction;
import org.vesalainen.parsers.sql.TruthValue;
import org.vesalainen.parsers.sql.UpdateableFetchResult;
import org.vesalainen.parsers.sql.util.ArrayMap;
import org.vesalainen.parsers.sql.util.JoinMap;

public abstract class Engine<R, C>
implements SQLConverter<R, C>,
Metadata {
    private SqlParser parser;
    private ArrayMap<Table<R, C>, TableContext<R, C>> others;

    public Engine() {
        this.parser = (SqlParser)GenClassFactory.getGenInstance(SqlParser.class);
    }

    protected Engine(Class<?> grammar) {
        this.parser = (SqlParser)GenClassFactory.getGenInstance(grammar);
    }

    public Statement prepare(String sql) {
        ArrayDeque tableListStack = new ArrayDeque();
        LinkedHashMap<String, Placeholder> placeholderMap = new LinkedHashMap<String, Placeholder>();
        return this.parser.parse(sql, this, tableListStack, placeholderMap, null);
    }

    public Statement prepare(InputStream is) {
        ArrayDeque tableListStack = new ArrayDeque();
        LinkedHashMap<String, Placeholder> placeholderMap = new LinkedHashMap<String, Placeholder>();
        return this.parser.parse(is, this, tableListStack, placeholderMap, null);
    }

    public FetchResult<R, C> show(String identifier) {
        FetchResult fr = new FetchResult(this, "Tablename");
        for (TableMetadata tm : this.getTables()) {
            fr.addRowArray(tm.getName());
        }
        return fr;
    }

    public FetchResult<R, C> describe(String tablename) {
        FetchResult fr = new FetchResult(this, "Column", "Count", "Indexed", "Unique");
        TableMetadata tm = this.getTableMetadata(tablename);
        for (ColumnMetadata cm : tm.getColumns()) {
            fr.addRowArray(cm.getName(), cm.getCount(), cm.isIndexed(), cm.isUnique());
        }
        return fr;
    }

    public void check(String sql) {
        this.parser.check(sql, null);
    }

    public void check(InputReader reader) {
        this.parser.check(reader, null);
    }

    public void check(InputReader reader, SQLLocator locator) {
        this.parser.check(reader, locator);
    }

    public FetchResult<R, C> execute(String sql) {
        Statement prepared = this.prepare(sql);
        return prepared.execute();
    }

    public FetchResult<R, C> execute(InputStream is) {
        Statement prepared = this.prepare(is);
        return prepared.execute();
    }

    public UpdateableFetchResult<R, C> selectForUpdate(SelectStatement<R, C> select) {
        UpdateableFetchResult<R, C> result = new UpdateableFetchResult<R, C>(this, select);
        this.select(select, result, true);
        return result;
    }

    public OrderedFetchResult<R, C> select(SelectStatement<R, C> select) {
        OrderedFetchResult<R, C> result = new OrderedFetchResult<R, C>(this, select);
        this.select(select, result, false);
        return result;
    }

    private void select(SelectStatement<R, C> select, OrderedFetchResult<R, C> result, boolean update) {
        this.others = new ArrayMap(select.getTables());
        TableContextComparator tableContextComparator = this.getTableContextComparator();
        ArrayMap<Table<R, C>, TableContext<R, C>> tableResults = new ArrayMap<Table<R, C>, TableContext<R, C>>(select.getTables());
        ArrayList tableList = new ArrayList();
        for (Table<R, C> table : select.getTables()) {
            TableContext<R, C> tc = this.createTableContext(table, this.others);
            this.others.put(table, tc);
            tableResults.put(table, tc);
            tableList.add(tc);
        }
        Condition condition = select.getCondition();
        if (condition == null && select.getTableCount() > 1) {
            throw new IllegalArgumentException("no conditions");
        }
        int index = tableList.size();
        TableContext[] resultArray = new TableContext[index];
        while (!tableList.isEmpty()) {
            Collections.sort(tableList, tableContextComparator);
            TableContext currentTable = (TableContext)tableList.get(0);
            Collection<R> rows = this.fetch(currentTable, update);
            resultArray[--index] = currentTable;
            currentTable.setData(rows);
            tableList.remove(currentTable);
            currentTable.updateHints(tableList);
        }
        this.sort(resultArray);
        ArrayMap rowCandidate = new ArrayMap(select.getTables());
        this.cartesian(condition, result, resultArray, rowCandidate);
    }

    private void cartesian(Condition condition, OrderedFetchResult results, TableContext[] resultArray, ArrayMap<Table<R, C>, R> rowCandidate) {
        int level = 0;
        Iterator[] iterator = new Iterator[resultArray.length];
        iterator[0] = resultArray[0].getAll().iterator();
        JoinMap[] joinMap = new JoinMap[resultArray.length - 1];
        for (int ii = 0; ii < joinMap.length; ++ii) {
            joinMap[ii] = resultArray[ii].getJoinMapTo(resultArray[ii + 1].getTable());
        }
        int[] tableIndex = new int[resultArray.length];
        for (int ii = 0; ii < tableIndex.length; ++ii) {
            tableIndex[ii] = rowCandidate.getIndexOf(resultArray[ii].getTable());
        }
        while (iterator[0].hasNext()) {
            while (iterator[level].hasNext()) {
                Object row = iterator[level].next();
                rowCandidate.put(tableIndex[level], row);
                if (level + 1 < resultArray.length) {
                    Set set = (Set)joinMap[level].get(row);
                    iterator[level + 1] = set.iterator();
                    ++level;
                    continue;
                }
                if (condition != null) {
                    if (condition.matches(this, rowCandidate) != TruthValue.TRUE) continue;
                    results.addRow(rowCandidate);
                    continue;
                }
                results.addRow(rowCandidate);
            }
            --level;
        }
    }

    protected TableContextComparator getTableContextComparator() {
        return new TableContextComparator(this);
    }

    protected Table<R, C> createTable(String schema, String tablename, String correlationName) {
        return new Table(this, schema, tablename, correlationName);
    }

    protected TableContext<R, C> createTableContext(Table<R, C> table, ArrayMap<Table<R, C>, TableContext<R, C>> others) {
        return new TableContext<R, C>(this, table, others);
    }

    public abstract void beginTransaction();

    public abstract void commitTransaction();

    public abstract void delete(Collection<R> var1);

    public abstract Collection<R> fetch(Table<R, C> var1);

    public abstract Collection<R> fetch(TableContext<R, C> var1, boolean var2);

    public abstract void insert(InsertStatement<R, C> var1);

    public abstract void rollbackTransaction();

    public abstract void update(Collection<R> var1);

    public abstract void exit();

    public abstract Class<? extends C> getDefaultPlaceholderType();

    public ColumnReference createFunction(ColumnReference inner, String funcName, String ... args) {
        switch (funcName.toLowerCase()) {
            case "upper": {
                this.check(funcName, args.length, 0, 0);
                return new AbstractFunction(inner){

                    @Override
                    public Object function(Object value) {
                        return value != null ? value.toString().toUpperCase() : null;
                    }
                };
            }
            case "lower": {
                this.check(funcName, args.length, 0, 0);
                return new AbstractFunction(inner){

                    @Override
                    public Object function(Object value) {
                        return value != null ? value.toString().toLowerCase() : null;
                    }
                };
            }
            case "extract": {
                this.check(funcName, args.length, 1, 1);
                return new ExtractFunction(inner, args[0]);
            }
            case "toint": {
                this.check(funcName, args.length, 0, 0);
                return new ToFunction(inner, Integer.class);
            }
            case "todouble": {
                this.check(funcName, args.length, 0, 0);
                return new ToFunction(inner, Double.class);
            }
            case "toboolean": {
                this.check(funcName, args.length, 0, 0);
                return new ToFunction(inner, Boolean.class);
            }
            case "tochar": 
            case "tostring": {
                this.check(funcName, args.length, 0, 1);
                return new ToStringFunction(inner, args);
            }
            case "todate": {
                this.check(funcName, args.length, 1, 1);
                return new ToDateFunction(inner, args);
            }
            case "format": {
                this.check(funcName, args.length, 1, 1);
                return new FormatFunction(inner, args[0]);
            }
            case "creditorreference": {
                this.check(funcName, args.length, 0, 0);
                return new CreditorReferenceFunction(inner);
            }
        }
        throw new IllegalArgumentException("This version doesn't support " + funcName + " function");
    }

    public ColumnReference createFunction(ColumnReference inner, String funcName, Number number, Number ... args) {
        switch (funcName.toLowerCase()) {
            case "substr": 
            case "substring": {
                this.check(funcName, args.length, 0, 1);
                return new SubStringFunction(inner, number, args);
            }
        }
        throw new IllegalArgumentException("This version doesn't support " + funcName + " function");
    }

    protected void check(String funcName, int len, int min, int max) {
        if (len < min || len > max) {
            throw new IllegalArgumentException("wrong number of string arguments for function " + funcName);
        }
    }

    private void sort(TableContext[] resultArray) {
        if (resultArray.length == 1) {
            return;
        }
        HashSet<TableContext> rest = new HashSet<TableContext>();
        for (TableContext tc : resultArray) {
            rest.add(tc);
        }
        OptRes min = this.findMin(Float.MAX_VALUE, 0.0f, rest, new ArrayDeque<TableContext>());
        for (int ii = resultArray.length - 1; ii >= 0; --ii) {
            resultArray[ii] = (TableContext)min.stack.pop();
        }
    }

    private OptRes findMin(float lastMin, float cum, HashSet<TableContext> rest, ArrayDeque<TableContext> stack) {
        OptRes best = null;
        if (stack.isEmpty()) {
            for (TableContext tc : rest) {
                HashSet clone = (HashSet)rest.clone();
                clone.remove(tc);
                stack.push(tc);
                OptRes res = this.findMin(lastMin, 0.0f, clone, stack);
                stack.pop();
                if (res == null || !(res.min < lastMin)) continue;
                lastMin = res.min;
                best = res;
            }
        } else if (!rest.isEmpty()) {
            TableContext prev = stack.peek();
            for (TableContext tc : rest) {
                JoinMap joinMapTo = prev.getJoinMapTo(tc.getTable());
                float cur = cum + joinMapTo.getRatio();
                if (!(cur < lastMin)) continue;
                HashSet clone = (HashSet)rest.clone();
                clone.remove(tc);
                stack.push(tc);
                OptRes res = this.findMin(lastMin, cur, clone, stack);
                stack.pop();
                if (res == null || !(res.min < lastMin)) continue;
                lastMin = res.min;
                best = res;
            }
        } else {
            return new OptRes((ArrayDeque<TableContext>)stack.clone(), cum);
        }
        return best;
    }

    private class OptRes {
        private ArrayDeque<TableContext> stack;
        private float min;

        public OptRes(ArrayDeque<TableContext> stack, float min) {
            this.stack = stack;
            this.min = min;
        }
    }
}

