/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.Calendar;
import java.util.Date;
import org.vesalainen.parsers.sql.AbstractFunction;
import org.vesalainen.parsers.sql.ColumnReference;

public class ExtractFunction
extends AbstractFunction {
    private Type type;

    public ExtractFunction(ColumnReference inner, String type) {
        super(inner);
        try {
            this.type = Type.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            inner.throwException(type + " not supported in extract");
        }
    }

    @Override
    public Object function(Object value) {
        if (value instanceof Date) {
            Date date = (Date)value;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            switch (this.type) {
                case SECOND: {
                    return cal.get(13);
                }
                case MINUTE: {
                    return cal.get(12);
                }
                case HOUR: {
                    return cal.get(11);
                }
                case DAY: {
                    return cal.get(5);
                }
                case WEEK: {
                    return cal.get(3);
                }
                case MONTH: {
                    return cal.get(2);
                }
                case YEAR: {
                    return cal.get(1);
                }
            }
            throw new UnsupportedOperationException(this.type.name());
        }
        throw new UnsupportedOperationException("extract not supported for " + value);
    }

    public static enum Type {
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

