/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.Engine;

public class FetchResult<R, C>
implements Iterable<C[]> {
    protected Engine<R, C> engine;
    protected List<ColumnReference<R, C>> subList;
    protected Map<String, Integer> columnMap = new HashMap<String, Integer>();
    protected String[] header;
    protected String[] display;
    protected int[] columnLength;
    protected List<C[]> data;
    protected int length;

    public FetchResult(Engine<R, C> engine, List<ColumnReference<R, C>> subList) {
        this.engine = engine;
        this.subList = subList;
        String[] hdr = new String[subList.size()];
        String[] dspl = new String[subList.size()];
        int index = 0;
        for (ColumnReference<R, C> cf : subList) {
            this.columnMap.put(cf.getColumn(), index);
            hdr[index] = cf.getColumn();
            dspl[index] = cf.getTitle();
            ++index;
        }
        this.header = hdr;
        this.display = dspl;
        this.init();
    }

    public FetchResult(Engine<R, C> engine, String ... header) {
        this.engine = engine;
        this.header = header;
        this.display = header;
        for (int ii = 0; ii < header.length; ++ii) {
            this.columnMap.put(header[ii], ii);
        }
        this.init();
    }

    private void init() {
        this.data = new ArrayList<C[]>();
        this.columnLength = new int[this.header.length];
        int index = 0;
        for (String h : this.header) {
            this.columnLength[index++] = h.length();
        }
    }

    public List<ColumnReference<R, C>> getSelectList() {
        return this.subList;
    }

    public int getColumnIndex(String column) {
        Integer i = this.columnMap.get(column);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public String[] getHeader() {
        return this.header;
    }

    public void setHeader(String[] header) {
        this.header = header;
    }

    public void addRowArray(C ... row) {
        this.data.add(row);
        int len = Math.min(this.columnLength.length, row.length);
        for (int ii = 0; ii < len; ++ii) {
            this.columnLength[ii] = Math.max(this.columnLength[ii], row[ii].toString().length());
        }
    }

    @Override
    public Iterator<C[]> iterator() {
        return this.data.iterator();
    }

    public void print(PrintStream out) {
        int index = 0;
        for (String h : this.display) {
            out.printf("%" + this.columnLength[index++] + "s ", h);
        }
        out.println();
        for (C[] ar : this) {
            index = 0;
            for (C col : ar) {
                out.printf("%" + this.columnLength[index++] + "s ", col);
            }
            out.println();
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.header.length;
    }

    public C getValueAt(int row, int column) {
        return this.data.get(row)[column];
    }

    public C getValueAt(int row, String column) {
        Integer col = this.columnMap.get(column);
        if (col == null) {
            return null;
        }
        return this.data.get(row)[col];
    }

    public String getColumnName(int columnIndex) {
        return this.header[columnIndex];
    }

    public String getDisplayName(int columnIndex) {
        return this.display[columnIndex];
    }
}

