/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import org.vesalainen.parsers.sql.FetchResult;
import org.vesalainen.parsers.sql.OrderedFetchResult;

public class FetchResultComboBoxModel<R, C>
extends DefaultComboBoxModel<String> {
    private FetchResult<R, C> result;
    private Map<String, C> map = new HashMap<String, C>();

    public FetchResultComboBoxModel(OrderedFetchResult<R, C> result) {
        this.result = result;
        int count = result.getColumnCount();
        for (int row = 0; row < result.getRowCount(); ++row) {
            String key = null;
            switch (count) {
                case 1: {
                    key = Objects.toString(result.getValueAt(row, 0), "");
                    break;
                }
                case 2: {
                    key = Objects.toString(result.getValueAt(row, 1), "");
                    break;
                }
                default: {
                    StringBuilder sb = new StringBuilder();
                    for (int ii = 1; ii < count; ++ii) {
                        sb.append(Objects.toString(result.getValueAt(row, ii), "") + " ");
                    }
                    key = sb.toString().trim();
                }
            }
            this.addElement(key);
            this.map.put(key, result.getValueAt(row, 0));
        }
    }

    public Object getOriginalSelectedItem() {
        return this.map.get((String)super.getSelectedItem());
    }
}

