/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.LinkedHashMap;
import java.util.List;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.ErrorReporter;
import org.vesalainen.parsers.sql.FetchResult;
import org.vesalainen.parsers.sql.InsertColumnsAndSource;
import org.vesalainen.parsers.sql.Literal;
import org.vesalainen.parsers.sql.Metadata;
import org.vesalainen.parsers.sql.Placeholder;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.Statement;
import org.vesalainen.parsers.sql.Table;

public class InsertStatement<R, C>
extends Statement<R, C> {
    private Table<R, C> table;
    private InsertColumnsAndSource<R, C> insertColumnsAndSource;
    private FetchResult<R, C> result;

    public InsertStatement(Engine<R, C> engine, LinkedHashMap<String, Placeholder<R, C>> placeholderMap, Table<R, C> table, InsertColumnsAndSource<R, C> insertColumnsAndSource) {
        super(engine, placeholderMap);
        this.table = table;
        this.insertColumnsAndSource = insertColumnsAndSource;
    }

    @Override
    public FetchResult<R, C> execute() {
        List<String> columnList = this.insertColumnsAndSource.getColumnList();
        List<Literal<R, C>> valueList = this.insertColumnsAndSource.getValueList();
        if (valueList != null) {
            this.result = new FetchResult(this.engine, columnList.toArray(new String[columnList.size()]));
            Object[] row = new Object[valueList.size()];
            int index = 0;
            for (Literal<R, C> lit : valueList) {
                row[index++] = lit.getValue();
            }
            this.result.addRowArray(row);
        } else {
            SelectStatement select = this.insertColumnsAndSource.getSelect();
            this.result = select.execute();
            this.result.setHeader(columnList.toArray(new String[columnList.size()]));
        }
        this.engine.insert(this);
        return null;
    }

    public FetchResult<R, C> getFetchResult() {
        return this.result;
    }

    public Table<R, C> getTable() {
        return this.table;
    }

    @Override
    public void check(Metadata metadata, ErrorReporter reporter) {
    }
}

