/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import org.vesalainen.parsers.sql.BaseComparison;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.ConditionVisitor;
import org.vesalainen.parsers.sql.JoinCondition;
import org.vesalainen.parsers.sql.Range;
import org.vesalainen.parsers.sql.Relation;
import org.vesalainen.parsers.sql.SQLConverter;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TruthValue;
import org.vesalainen.parsers.sql.util.ArrayMap;

public class JoinComparison<R, C>
extends BaseComparison<R, C>
implements JoinCondition<R, C> {
    protected JoinComparison<R, C> pair;
    protected ColumnReference<R, C> columnReference2;

    public JoinComparison(ColumnReference<R, C> columnReference, Relation relation, ColumnReference<R, C> columnReference2) {
        super(columnReference, relation);
        this.columnReference2 = columnReference2;
        this.pair = new JoinComparison<R, C>(this);
    }

    private JoinComparison(JoinComparison<R, C> pair) {
        super(pair.columnReference2, pair.relation);
        this.columnReference2 = pair.columnReference;
        this.pair = pair;
    }

    @Override
    public TruthValue matches(SQLConverter<R, C> selector, R row) {
        C col1 = this.columnReference.getValue(selector, row);
        C col2 = this.columnReference2.getValue(selector, row);
        if (col1 == null || col2 == null) {
            return TruthValue.UNKNOWN;
        }
        if (this.matches(selector, col1, col2)) {
            return TruthValue.TRUE;
        }
        return TruthValue.FALSE;
    }

    @Override
    public TruthValue matches(SQLConverter<R, C> selector, ArrayMap<Table<R, C>, R> rowCandidate) {
        C col1 = this.columnReference.getValue(selector, rowCandidate);
        C col2 = this.columnReference2.getValue(selector, rowCandidate);
        if (col1 == null || col2 == null) {
            return TruthValue.UNKNOWN;
        }
        if (this.matches(selector, col1, col2)) {
            return TruthValue.TRUE;
        }
        return TruthValue.FALSE;
    }

    @Override
    public void associateCondition(SelectStatement select, boolean andPath) {
        this.columnReference.associateCondition(this, andPath);
        this.columnReference2.associateCondition(this.pair, andPath);
    }

    @Override
    public Range<C> narrow(SQLConverter<R, C> selector, Range<C> range, Table fromTable, String column, C lower, C upper) {
        range = this.narrow(this.columnReference, selector, range, fromTable, column, lower, upper);
        range = this.narrow(this.columnReference2, selector, range, fromTable, column, lower, upper);
        return range;
    }

    private Range<C> narrow(ColumnReference cf, SQLConverter<R, C> selector, Range<C> range, Table fromTable, String column, C lower, C upper) {
        if (fromTable.equals(cf.getTable()) && column.equals(cf.getColumn())) {
            if (range == null) {
                range = new Range<C>(selector.getComparator());
            }
            range.narrow(lower, upper);
        }
        return range;
    }

    @Override
    public void narrow(SQLConverter<R, C> selector, Range<C> range) {
    }

    @Override
    public void walk(ConditionVisitor visitor, boolean andPath) {
        visitor.visit(this, andPath);
    }

    @Override
    public ColumnReference<R, C> getColumnReference2() {
        return this.columnReference2;
    }

    @Override
    public String getColumn() {
        return this.columnReference.getColumn();
    }

    @Override
    public ColumnReference<R, C> getColumnReference() {
        return this.columnReference;
    }
}

