/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.io.IOException;
import org.vesalainen.parsers.sql.ColumnCondition;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.ConditionVisitor;
import org.vesalainen.parsers.sql.ParserLocator2Impl;
import org.vesalainen.parsers.sql.Range;
import org.vesalainen.parsers.sql.SQLConverter;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TruthValue;
import org.vesalainen.parsers.sql.util.ArrayMap;
import org.vesalainen.regex.Regex;

public class LikeCondition<R, C>
extends ParserLocator2Impl
implements ColumnCondition<R, C> {
    private ColumnReference<R, C> columnReference;
    private Regex pattern;

    public LikeCondition(ColumnReference<R, C> rv, String pattern) {
        this.columnReference = rv;
        try {
            this.pattern = Regex.compile((String)Regex.escape((String)pattern).replace("%", ".*").replace("_", ".?"), (Regex.Option[])new Regex.Option[0]);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public LikeCondition(ColumnReference<R, C> rv, String pattern, String escape) {
        this.columnReference = rv;
        try {
            this.pattern = Regex.compile((String)Regex.escape((String)pattern).replace(escape, ".*").replace("_", ".?"), (Regex.Option[])new Regex.Option[0]);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public void associateCondition(SelectStatement select, boolean andPath) {
    }

    @Override
    public TruthValue matches(SQLConverter<R, C> selector, R row) {
        C col = this.columnReference.getValue(selector, row);
        if (col == null) {
            return TruthValue.UNKNOWN;
        }
        if (this.pattern.isMatch((CharSequence)col.toString())) {
            return TruthValue.TRUE;
        }
        return TruthValue.FALSE;
    }

    @Override
    public TruthValue matches(SQLConverter<R, C> selector, ArrayMap<Table<R, C>, R> rowCandidate) {
        C col = this.columnReference.getValue(selector, rowCandidate);
        if (col == null) {
            return TruthValue.UNKNOWN;
        }
        if (this.pattern.isMatch((CharSequence)col.toString())) {
            return TruthValue.TRUE;
        }
        return TruthValue.FALSE;
    }

    @Override
    public void narrow(SQLConverter<R, C> selector, Range<C> range) {
    }

    @Override
    public void walk(ConditionVisitor visitor, boolean andPath) {
        visitor.visit(this, andPath);
    }

    @Override
    public String getColumn() {
        return this.columnReference.getColumn();
    }

    @Override
    public ColumnReference<R, C> getColumnReference() {
        return this.columnReference;
    }
}

