/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import org.vesalainen.parsers.sql.BaseComparison;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.ConditionVisitor;
import org.vesalainen.parsers.sql.Literal;
import org.vesalainen.parsers.sql.Range;
import org.vesalainen.parsers.sql.Relation;
import org.vesalainen.parsers.sql.SQLConverter;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TruthValue;
import org.vesalainen.parsers.sql.ValueComparisonCondition;
import org.vesalainen.parsers.sql.util.ArrayMap;

public class LiteralComparison<R, C>
extends BaseComparison<R, C>
implements ValueComparisonCondition<R, C> {
    private Literal<R, C> literal;

    public LiteralComparison(ColumnReference<R, C> columnReference, Relation relation, Literal<R, C> literal) {
        super(columnReference, relation);
        this.literal = literal;
    }

    @Override
    public void associateCondition(SelectStatement select, boolean andPath) {
        this.columnReference.associateCondition(this, andPath);
    }

    @Override
    public TruthValue matches(SQLConverter<R, C> selector, R row) {
        C col1 = this.columnReference.getValue(selector, row);
        C col2 = this.literal.getValue();
        if (col1 == null || col2 == null) {
            return TruthValue.UNKNOWN;
        }
        if (this.matches(selector, col1, col2)) {
            return TruthValue.TRUE;
        }
        return TruthValue.FALSE;
    }

    @Override
    public TruthValue matches(SQLConverter<R, C> selector, ArrayMap<Table<R, C>, R> rowCandidate) {
        C col1 = this.columnReference.getValue(selector, rowCandidate);
        C col2 = this.literal.getValue();
        if (col1 == null || col2 == null) {
            return TruthValue.UNKNOWN;
        }
        if (this.matches(selector, col1, col2)) {
            return TruthValue.TRUE;
        }
        return TruthValue.FALSE;
    }

    @Override
    public void narrow(SQLConverter<R, C> selector, Range<C> range) {
        C value = this.literal.getValue();
        switch (this.relation) {
            case EQ: {
                range.narrow(value, value);
                break;
            }
            case LT: 
            case LE: {
                range.upper(value);
                break;
            }
            case GT: 
            case GE: {
                range.lower(value);
            }
        }
    }

    @Override
    public C getValue() {
        return this.literal.getValue();
    }

    @Override
    public String getColumn() {
        return this.columnReference.getColumn();
    }

    @Override
    public void walk(ConditionVisitor visitor, boolean andPath) {
        visitor.visit(this, andPath);
    }
}

