/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.Objects;
import org.vesalainen.parsers.sql.Condition;
import org.vesalainen.parsers.sql.ConditionVisitor;
import org.vesalainen.parsers.sql.ParserLocator2Impl;
import org.vesalainen.parsers.sql.SQLConverter;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TruthValue;
import org.vesalainen.parsers.sql.util.ArrayMap;

class NotCondition<R, C>
extends ParserLocator2Impl
implements Condition<R, C> {
    private Condition test;

    public NotCondition(Condition test) {
        this.test = test;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotCondition other = (NotCondition)obj;
        return Objects.equals(this.test, other.test);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.test);
        return hash;
    }

    @Override
    public void associateCondition(SelectStatement select, boolean andPath) {
        this.test.associateCondition(select, false);
    }

    @Override
    public TruthValue matches(SQLConverter<R, C> selector, ArrayMap<Table<R, C>, R> rowCandidate) {
        return NotCondition.truthTable(this.test.matches(selector, rowCandidate));
    }

    public static TruthValue truthTable(TruthValue p) {
        switch (p) {
            case TRUE: {
                return TruthValue.FALSE;
            }
            case FALSE: {
                return TruthValue.TRUE;
            }
            case UNKNOWN: {
                return TruthValue.UNKNOWN;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void walk(ConditionVisitor visitor, boolean andPath) {
        visitor.visit(this, andPath);
        this.test.walk(visitor, false);
    }
}

