/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;

public class ObjectComparator
implements Comparator<Object> {
    public static final ObjectComparator STATIC = new ObjectComparator();

    @Override
    public int compare(Object o1, Object o2) {
        assert (o1 != null && o2 != null);
        Class<?> c1 = o1.getClass();
        if (c1.equals(o2.getClass()) && o1 instanceof Comparable) {
            try {
                Method m = c1.getMethod("compareTo", c1);
                return (Integer)m.invoke(o1, o2);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            return Double.compare(n1.doubleValue(), n2.doubleValue());
        }
        throw new UnsupportedOperationException("Comparing " + o1 + " to " + o2 + " not supported");
    }
}

