/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.Objects;
import org.vesalainen.parsers.sql.Condition;
import org.vesalainen.parsers.sql.ConditionVisitor;
import org.vesalainen.parsers.sql.ParserLocator2Impl;
import org.vesalainen.parsers.sql.SQLConverter;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TruthValue;
import org.vesalainen.parsers.sql.util.ArrayMap;

public class OrCondition<R, C>
extends ParserLocator2Impl
implements Condition<R, C> {
    private Condition condition1;
    private Condition condition2;

    public OrCondition(Condition condition1, Condition condition2) {
        this.condition1 = condition1;
        this.condition2 = condition2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrCondition other = (OrCondition)obj;
        if (!Objects.equals(this.condition1, other.condition1)) {
            return false;
        }
        return Objects.equals(this.condition2, other.condition2);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.condition1);
        hash = 97 * hash + Objects.hashCode(this.condition2);
        return hash;
    }

    @Override
    public void associateCondition(SelectStatement select, boolean andPath) {
        this.condition1.associateCondition(select, false);
        this.condition2.associateCondition(select, false);
    }

    @Override
    public TruthValue matches(SQLConverter<R, C> selector, ArrayMap<Table<R, C>, R> rowCandidate) {
        TruthValue p = this.condition1.matches(selector, rowCandidate);
        if (TruthValue.TRUE.equals((Object)p)) {
            return TruthValue.TRUE;
        }
        TruthValue q = this.condition2.matches(selector, rowCandidate);
        return OrCondition.truthTable(p, q);
    }

    public static TruthValue truthTable(TruthValue p, TruthValue q) {
        switch (p) {
            case FALSE: {
                switch (q) {
                    case TRUE: {
                        return TruthValue.TRUE;
                    }
                    case FALSE: {
                        return TruthValue.FALSE;
                    }
                    case UNKNOWN: {
                        return TruthValue.UNKNOWN;
                    }
                }
            }
            case UNKNOWN: {
                switch (q) {
                    case TRUE: {
                        return TruthValue.TRUE;
                    }
                    case FALSE: {
                        return TruthValue.UNKNOWN;
                    }
                    case UNKNOWN: {
                        return TruthValue.UNKNOWN;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void walk(ConditionVisitor visitor, boolean andPath) {
        visitor.visit(this, andPath);
        this.condition1.walk(visitor, false);
        this.condition2.walk(visitor, false);
    }
}

