/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.FetchResult;
import org.vesalainen.parsers.sql.SQLConverter;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.SortSpecification;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.util.ArrayMap;

public class OrderedFetchResult<R, C>
extends FetchResult<R, C> {
    protected List<ColumnReference<R, C>> columnReferences;
    protected boolean sorted;
    protected final List<SortSpecification> sortSpecification;

    public OrderedFetchResult(Engine<R, C> engine, SelectStatement<R, C> select) {
        super(engine, select.getSelectList());
        this.data = new ArrayList();
        this.columnReferences = select.getReferencedColumns();
        this.length = this.columnReferences.size();
        this.columnLength = Arrays.copyOf(this.columnLength, this.length);
        this.sortSpecification = select.getSortSpecification();
    }

    public void addRow(ArrayMap<Table<R, C>, R> rowCandidate) {
        Object[] row = new Object[this.length];
        this.data.add(row);
        int index = 0;
        for (ColumnReference<R, C> cf : this.columnReferences) {
            C col = cf.getValue((SQLConverter<R, C>)this.engine, rowCandidate);
            if (col != null) {
                this.columnLength[index] = Math.max(this.columnLength[index], col.toString().length());
            }
            row[index++] = col;
        }
    }

    @Override
    public void print(PrintStream out) {
        this.checkSorting();
        super.print(out);
    }

    @Override
    public C getValueAt(int row, int column) {
        this.checkSorting();
        return super.getValueAt(row, column);
    }

    @Override
    public C getValueAt(int row, String column) {
        this.checkSorting();
        return super.getValueAt(row, column);
    }

    @Override
    public Iterator<C[]> iterator() {
        this.checkSorting();
        return this.data.iterator();
    }

    private void checkSorting() {
        if (!this.sorted && this.sortSpecification != null) {
            ArrayComparator comparator = new ArrayComparator(this.engine.getComparator(), this.columnReferences, this.sortSpecification);
            Collections.sort(this.data, comparator);
            this.sorted = true;
        }
    }

    private class ArrayComparator
    implements Comparator<C[]> {
        private Comparator<C> comp;
        private int[] cols;
        private int[] signs;

        public ArrayComparator(Comparator<C> comp, List<ColumnReference<R, C>> columnReferences, List<SortSpecification> sortSpecification) {
            this.comp = comp;
            this.cols = new int[sortSpecification.size()];
            this.signs = new int[sortSpecification.size()];
            int index = 0;
            for (SortSpecification ss : sortSpecification) {
                this.cols[index] = columnReferences.indexOf(ss.getRv());
                this.signs[index] = ss.isAscending() ? 1 : -1;
                ++index;
            }
        }

        @Override
        public int compare(C[] o1, C[] o2) {
            int cmp = 0;
            for (int ii = 0; ii < this.cols.length && (cmp = this.signs[ii] * this.comp.compare(o1[this.cols[ii]], o2[this.cols[ii]])) == 0; ++ii) {
            }
            return cmp;
        }
    }
}

