/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import javax.swing.ComboBoxModel;
import org.vesalainen.parsers.sql.FetchResultComboBoxModel;
import org.vesalainen.parsers.sql.Literal;
import org.vesalainen.parsers.sql.LiteralImpl;
import org.vesalainen.parsers.sql.OrderedFetchResult;
import org.vesalainen.parsers.sql.Placeholder;
import org.vesalainen.parsers.sql.SelectStatement;

public class PlaceholderImpl<R, C>
extends LiteralImpl<R, C>
implements Placeholder<R, C> {
    private String name;
    private Class<?> type;
    private SelectStatement<R, C> select;

    public PlaceholderImpl(String name, Class<? extends C> type) {
        super(null);
        this.name = name;
        this.type = type;
    }

    public PlaceholderImpl(String name, Literal<R, C> defaultValue) {
        super(null);
        this.name = name;
        C val = defaultValue.getValue();
        if (val == null) {
            throw new IllegalArgumentException("Placeholder :" + name + " default value = null! Nested placeholders not supported!");
        }
        this.value = val;
        this.type = val.getClass();
    }

    public PlaceholderImpl(String name, SelectStatement<R, C> select) {
        super(null);
        this.name = name;
        this.select = select;
        this.type = ComboBoxModel.class;
    }

    @Override
    public Object getDefaultValue() {
        if (this.select != null) {
            OrderedFetchResult result = this.select.execute();
            FetchResultComboBoxModel model = new FetchResultComboBoxModel(result);
            return model;
        }
        return super.getValue();
    }

    @Override
    public void bindValue(C newValue) {
        if (newValue instanceof FetchResultComboBoxModel) {
            FetchResultComboBoxModel model = (FetchResultComboBoxModel)newValue;
            this.value = model.getOriginalSelectedItem();
        } else if (this.type.isAssignableFrom(newValue.getClass())) {
            this.value = newValue;
        } else {
            throw new IllegalArgumentException(newValue + " type is not " + this.type);
        }
    }

    @Override
    public void setType(Class<? extends C> type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isBound() {
        return this.value != null;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

