/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.Comparator;

public class Range<C> {
    Comparator<C> comparator;
    private C lower;
    private C upper;

    public Range(Comparator<C> comparator) {
        this.comparator = comparator;
    }

    public Range(Comparator<C> comparator, C lower, C upper) {
        this.comparator = comparator;
        this.lower = lower;
        this.upper = upper;
    }

    public void narrow(C lower, C upper) {
        if (this.lower == null || this.comparator.compare(this.lower, lower) < 0) {
            this.lower = lower;
        }
        if (this.upper == null || this.comparator.compare(this.upper, upper) > 0) {
            this.upper = upper;
        }
    }

    public void lower(C lower) {
        if (this.lower == null || this.comparator.compare(this.lower, lower) < 0) {
            this.lower = lower;
        }
    }

    public void upper(C upper) {
        if (this.upper == null || this.comparator.compare(this.upper, upper) > 0) {
            this.upper = upper;
        }
    }

    public void exact(C item) {
        this.lower = item;
        this.upper = item;
    }

    public boolean inRange(C item) {
        return !(this.lower != null && this.comparator.compare(this.lower, item) > 0 || this.upper != null && this.comparator.compare(this.upper, item) < 0);
    }

    public boolean isSingle() {
        return this.lower != null && this.lower.equals(this.upper);
    }
}

