/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.vesalainen.parsers.sql.ColumnCondition;
import org.vesalainen.parsers.sql.ColumnMetadata;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.ColumnReferenceImpl;
import org.vesalainen.parsers.sql.Condition;
import org.vesalainen.parsers.sql.ConditionVisitor;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.ErrorReporter;
import org.vesalainen.parsers.sql.JoinCondition;
import org.vesalainen.parsers.sql.Metadata;
import org.vesalainen.parsers.sql.OrderedFetchResult;
import org.vesalainen.parsers.sql.Placeholder;
import org.vesalainen.parsers.sql.RowValue;
import org.vesalainen.parsers.sql.SortSpecification;
import org.vesalainen.parsers.sql.Statement;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TableExpression;
import org.vesalainen.parsers.sql.TableMetadata;
import org.vesalainen.parsers.sql.UpdateableFetchResult;

public class SelectStatement<R, C>
extends Statement<R, C> {
    private List<ColumnReference<R, C>> subList;
    private List<Table<R, C>> tableList;
    private Condition<R, C> condition;
    private List<SortSpecification> sortSpecification;
    private Metadata metadata;
    private ErrorReporter reporter;

    public SelectStatement(Engine<R, C> engine, LinkedHashMap<String, Placeholder<R, C>> placeholderMap, List<ColumnReference<R, C>> selectList, TableExpression tableExpression) {
        super(engine, placeholderMap);
        this.subList = selectList;
        this.tableList = tableExpression.getTableList();
        this.condition = tableExpression.getCondition();
        this.sortSpecification = tableExpression.getSortSpecificationList();
        this.resolv();
        if (this.condition != null) {
            this.condition.associateCondition(this, true);
        }
        if (this.subList == null) {
            this.subList = new ArrayList<ColumnReference<R, C>>();
            for (Table<R, C> table : this.tableList) {
                TableMetadata tm = engine.getTableMetadata(table.getName());
                if (tm == null) continue;
                for (ColumnMetadata cm : tm.getColumns()) {
                    this.subList.add(new ColumnReferenceImpl<R, C>(table, cm.getName()));
                }
            }
        }
    }

    private void resolv() {
        if (this.subList != null) {
            for (ColumnReference<R, C> cf : this.subList) {
                this.resolvColumnReference(cf);
                Table<R, C> table = cf.getTable();
                table.addSelectListColumn(cf.getColumn());
            }
        }
        if (this.condition != null) {
            this.condition.walk(new Resolver(), true);
        }
        if (this.sortSpecification != null) {
            for (SortSpecification ss : this.sortSpecification) {
                RowValue rv = ss.getRv();
                if (!(rv instanceof ColumnReference)) continue;
                ColumnReference cf = (ColumnReference)rv;
                this.resolvColumnReference(cf);
                Table table = cf.getTable();
                table.addSortColumn(cf.getColumn());
            }
        }
    }

    private void resolvColumnReference(ColumnReference<R, C> cf) {
        cf.resolvTable(this.tableList);
    }

    @Override
    public void check(Metadata metadata, ErrorReporter reporter) {
        super.check(metadata, reporter);
        this.metadata = metadata;
        this.reporter = reporter;
        for (ColumnReference<R, C> columnReference : this.subList) {
            this.checkColumnReference(columnReference, metadata, reporter);
        }
        for (Table table : this.tableList) {
            if (table.getName() == null) continue;
            TableMetadata tm = metadata.getTableMetadata(table.getName());
            if (tm != null) {
                if (table.getName().equals(tm.getName())) continue;
                reporter.replace(tm.getName(), table.getStart(), table.getStart() + tm.getName().length());
                continue;
            }
            reporter.report("table " + table.getName() + " not defined", ErrorReporter.Level.Hint, table.getSource(), table.getStart(), table.getEnd());
        }
        if (this.condition != null) {
            this.condition.walk(new Checker(), true);
        }
        if (this.sortSpecification != null) {
            for (SortSpecification sortSpecification : this.sortSpecification) {
                RowValue rv = sortSpecification.getRv();
                if (!(rv instanceof ColumnReference)) continue;
                ColumnReference cf = (ColumnReference)rv;
                this.checkColumnReference(cf, metadata, reporter);
            }
        }
        this.metadata = null;
        this.reporter = null;
    }

    private void checkColumnReference(ColumnReference<R, C> cf, Metadata metadata, ErrorReporter reporter) {
        Table<R, C> table = cf.getTable();
        if (table.getName() == null) {
            String msg = cf + " table not specified";
            reporter.report(msg, ErrorReporter.Level.Fatal, cf.getSource(), cf.getStart(), cf.getEnd());
        } else {
            TableMetadata tm = metadata.getTableMetadata(table.getName());
            if (tm != null) {
                ColumnMetadata cm;
                if (!table.getName().equals(tm.getName())) {
                    reporter.replace(tm.getName(), cf.getStart(), cf.getStart() + tm.getName().length());
                }
                if ((cm = tm.getColumnMetadata(cf.getColumn())) != null) {
                    if (!cf.getColumn().equals(cm.getName())) {
                        reporter.replace(cm.getName(), cf.getEnd() - cf.getColumn().length(), cf.getEnd());
                    }
                } else {
                    reporter.report("column " + cf.getColumn() + " not defined", ErrorReporter.Level.Hint, cf.getSource(), cf.getEnd() - cf.getColumn().length(), cf.getEnd());
                }
            } else {
                reporter.report("table " + table.getName() + " not defined", ErrorReporter.Level.Hint, cf.getSource(), cf.getStart(), cf.getEnd());
            }
        }
    }

    public OrderedFetchResult execute() {
        return this.engine.select(this);
    }

    public UpdateableFetchResult selectForUpdate() {
        this.engine.beginTransaction();
        return this.engine.selectForUpdate(this);
    }

    public Collection<Table<R, C>> getTables() {
        return this.tableList;
    }

    void setWhereClause(Condition condition) {
        this.condition = condition;
    }

    void setOrderByClause(List<SortSpecification> list) {
        this.sortSpecification = list;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public List<SortSpecification> getSortSpecification() {
        return this.sortSpecification;
    }

    public List<ColumnReference<R, C>> getSelectList() {
        return this.subList;
    }

    public List<ColumnReference<R, C>> getReferencedColumns() {
        if (this.sortSpecification == null || this.sortSpecification.isEmpty()) {
            return this.subList;
        }
        ArrayList<ColumnReference<R, C>> list = new ArrayList<ColumnReference<R, C>>();
        list.addAll(this.subList);
        for (SortSpecification ss : this.sortSpecification) {
            if (list.contains(ss.getRv())) continue;
            list.add((ColumnReference)ss.getRv());
        }
        return list;
    }

    @Override
    public boolean isSelectStatement() {
        return true;
    }

    public int getTableCount() {
        return this.tableList.size();
    }

    private class Checker
    implements ConditionVisitor {
        private Checker() {
        }

        @Override
        public void visit(Condition condition, boolean andPath) {
            ColumnReference cf;
            if (condition instanceof ColumnCondition) {
                ColumnCondition cc = (ColumnCondition)condition;
                cf = cc.getColumnReference();
                SelectStatement.this.checkColumnReference(cf, SelectStatement.this.metadata, SelectStatement.this.reporter);
            }
            if (condition instanceof JoinCondition) {
                JoinCondition jc = (JoinCondition)condition;
                cf = jc.getColumnReference2();
                SelectStatement.this.checkColumnReference(cf, SelectStatement.this.metadata, SelectStatement.this.reporter);
            }
        }
    }

    private class Resolver
    implements ConditionVisitor {
        private Resolver() {
        }

        @Override
        public void visit(Condition condition, boolean andPath) {
            Table table;
            ColumnReference cf;
            if (condition instanceof ColumnCondition) {
                ColumnCondition cc = (ColumnCondition)condition;
                cf = cc.getColumnReference();
                SelectStatement.this.resolvColumnReference(cf);
                table = cf.getTable();
                table.addConditionColumn(cf.getColumn());
            }
            if (condition instanceof JoinCondition) {
                JoinCondition jc = (JoinCondition)condition;
                cf = jc.getColumnReference2();
                SelectStatement.this.resolvColumnReference(cf);
                table = cf.getTable();
                table.addConditionColumn(cf.getColumn());
            }
        }
    }
}

