/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.LinkedHashMap;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.ErrorReporter;
import org.vesalainen.parsers.sql.FetchResult;
import org.vesalainen.parsers.sql.Metadata;
import org.vesalainen.parsers.sql.ParserLocator2Impl;
import org.vesalainen.parsers.sql.Placeholder;

public abstract class Statement<R, C>
extends ParserLocator2Impl {
    protected Engine<R, C> engine;
    protected LinkedHashMap<String, Placeholder<R, C>> placeholderMap;

    public Statement(Engine<R, C> engine, LinkedHashMap<String, Placeholder<R, C>> placeholderMap) {
        this.engine = engine;
        this.placeholderMap = placeholderMap;
    }

    public LinkedHashMap<String, Placeholder<R, C>> getPlaceholderMap() {
        return this.placeholderMap;
    }

    public void bindValue(String name, C value) {
        Placeholder<R, C> ph = this.placeholderMap.get(name);
        if (ph == null) {
            throw new IllegalArgumentException("Placeholder " + name + " doesn't exist");
        }
        ph.bindValue(value);
    }

    public void check(Metadata metadata, ErrorReporter reporter) {
    }

    public abstract FetchResult<R, C> execute();

    public boolean isSelectStatement() {
        return false;
    }
}

