/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import org.vesalainen.parsers.sql.AbstractFunction;
import org.vesalainen.parsers.sql.ColumnReference;

public class SubStringFunction
extends AbstractFunction {
    private int begin;
    private int end;

    public SubStringFunction(ColumnReference inner, Number begin, Number ... length) {
        super(inner);
        this.begin = begin.intValue();
        switch (length.length) {
            case 0: {
                break;
            }
            case 1: {
                this.end = this.begin + length[0].intValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong number of arguments");
            }
        }
    }

    @Override
    public Object function(Object value) {
        if (value != null) {
            if (this.end > 0) {
                return value.toString().substring(this.begin, this.end);
            }
            return value.toString().substring(this.begin);
        }
        return null;
    }
}

