/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.HashSet;
import java.util.Set;
import org.vesalainen.parsers.sql.ColumnCondition;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.ParserLocator2Impl;

public class Table<R, C>
extends ParserLocator2Impl {
    protected Engine<R, C> engine;
    protected String name;
    private final String schema;
    private final String correlationName;
    protected Set<String> selectListColumns = new HashSet<String>();
    protected Set<String> conditionColumns = new HashSet<String>();
    protected Set<String> andColumns = new HashSet<String>();
    protected Set<String> sortColumns = new HashSet<String>();
    protected Set<ColumnCondition<R, C>> andConditions = new HashSet<ColumnCondition<R, C>>();
    protected Set<ColumnCondition<R, C>> conditions = new HashSet<ColumnCondition<R, C>>();

    protected Table(Engine<R, C> engine, String schema, String tablename, String correlationName) {
        this.engine = engine;
        this.schema = schema;
        this.name = tablename;
        this.correlationName = correlationName;
    }

    public boolean nameMatches(String str) {
        return str.equalsIgnoreCase(this.name) || str.equalsIgnoreCase(this.correlationName);
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCorrelationName() {
        return this.correlationName;
    }

    public void addSelectListColumn(String column) {
        this.selectListColumns.add(column);
    }

    public void addConditionColumn(String column) {
        this.conditionColumns.add(column);
    }

    public void associateCondition(ColumnCondition<R, C> condition, boolean andPath) {
        this.conditions.add(condition);
        if (andPath) {
            this.andConditions.add(condition);
            this.andColumns.add(condition.getColumn());
        }
    }

    public Set<String> getSelectListColumns() {
        return this.selectListColumns;
    }

    public Set<String> getConditionColumns() {
        return this.conditionColumns;
    }

    public void addAndColumn(String column) {
        this.andColumns.add(column);
    }

    public Set<String> getAndColumns() {
        return this.andColumns;
    }

    public Set<ColumnCondition<R, C>> getConditions() {
        return this.conditions;
    }

    public Set<ColumnCondition<R, C>> getAndConditions() {
        return this.andConditions;
    }

    public String toString() {
        return this.name;
    }

    public void addSortColumn(String column) {
        this.sortColumns.add(column);
    }

    public Set<String> getSortColumns() {
        return this.sortColumns;
    }
}

