/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.vesalainen.parsers.sql.ColumnCondition;
import org.vesalainen.parsers.sql.ColumnMetadata;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.JoinCondition;
import org.vesalainen.parsers.sql.Range;
import org.vesalainen.parsers.sql.Relation;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TableMetadata;
import org.vesalainen.parsers.sql.util.ArrayMap;
import org.vesalainen.parsers.sql.util.CartesianMap;
import org.vesalainen.parsers.sql.util.FastSet;
import org.vesalainen.parsers.sql.util.JoinMap;
import org.vesalainen.parsers.sql.util.JoinMapImpl;
import org.vesalainen.parsers.sql.util.SingleSubSet;

public class TableContext<R, C> {
    private Engine<R, C> selector;
    private Table<R, C> table;
    private Map<String, Range<C>> columnRanges = new HashMap<String, Range<C>>();
    private Map<String, NavigableMap<C, Set<R>>> indexes = new HashMap<String, NavigableMap<C, Set<R>>>();
    private FastSet<R> all;
    private ArrayMap<Table<R, C>, TableContext<R, C>> others;
    private Map<Table, JoinMap<R>> joinMaps = new HashMap<Table, JoinMap<R>>();
    private TableMetadata metadata;

    public TableContext(Engine<R, C> selector, Table<R, C> table, ArrayMap<Table<R, C>, TableContext<R, C>> others) {
        this.selector = selector;
        this.table = table;
        this.others = others;
        this.metadata = selector.getTableMetadata(table.getName());
        for (ColumnCondition<R, C> cc : table.getAndConditions()) {
            String column = cc.getColumn();
            Range<C> range = this.columnRanges.get(column);
            if (range == null) {
                range = new Range(selector.getComparator());
                this.columnRanges.put(column, range);
            }
            cc.narrow(selector, range);
        }
    }

    public JoinMap<R> getJoinMapTo(Table table) {
        JoinMap<R> map = this.joinMaps.get(table);
        if (map == null) {
            return new CartesianMap<R>(this.all, this.others.get((Object)table).all);
        }
        return map;
    }

    public TableContext<R, C> getOther(Table table) {
        return this.others.get(table);
    }

    public void setData(Collection<R> rows) {
        assert (this.all == null);
        this.all = new FastSet<R>(rows, true);
        for (String string : this.table.getAndColumns()) {
            TreeMap map = new TreeMap(this.selector.getComparator());
            this.indexes.put(string, map);
        }
        for (String string : this.indexes.keySet()) {
            ColumnMetadata columnMetadata;
            boolean unique = false;
            if (this.metadata != null && (columnMetadata = this.metadata.getColumnMetadata(string)) != null) {
                unique = columnMetadata.isUnique();
            }
            NavigableMap<C, Set<R>> map = this.indexes.get(string);
            for (R row : rows) {
                Object value = this.selector.get(row, string);
                if (value == null) continue;
                AbstractSet set = (SingleSubSet<R>)map.get(value);
                if (set == null) {
                    set = unique ? this.all.singleSub() : this.all.sub();
                    map.put(value, set);
                }
                set.add(row);
            }
        }
        for (ColumnCondition columnCondition : this.table.getAndConditions()) {
            JoinMap<R> oldMapThis;
            ColumnReference otherCr;
            Table otherTable;
            TableContext<R, C> otherCtx;
            JoinCondition jc;
            if (!(columnCondition instanceof JoinCondition) || !Relation.EQ.equals((Object)(jc = (JoinCondition)columnCondition).getRelation()) || !(otherCtx = this.others.get(otherTable = (otherCr = jc.getColumnReference2()).getTable())).hasData()) continue;
            ColumnReference thisCr = jc.getColumnReference();
            String thisColumn = thisCr.getColumn();
            NavigableMap<C, Set<R>> thisMap = this.indexes.get(thisColumn);
            String otherColumn = otherCr.getColumn();
            NavigableMap<C, Set<R>> otherMap = otherCtx.indexes.get(otherColumn);
            if (thisMap.isEmpty() || otherMap.isEmpty()) {
                this.removeAll();
                super.removeAll();
                continue;
            }
            JoinMap<R>[] mergeMaps = this.merge(thisMap, otherMap);
            JoinMap<R> oldMapOther = this.joinMaps.get(otherTable);
            if (oldMapOther == null || oldMapOther.size() > mergeMaps[0].size()) {
                this.joinMaps.put(otherTable, mergeMaps[0]);
            }
            if ((oldMapThis = this.joinMaps.get(this.table)) == null || oldMapThis.size() > mergeMaps[1].size()) {
                this.joinMaps.put(this.table, mergeMaps[1]);
            }
            System.err.println("merged " + this.table + " to " + this.all.size());
            System.err.println("merged " + otherTable + " to " + otherCtx.all.size());
        }
    }

    private JoinMap<R>[] merge(NavigableMap<C, Set<R>> thisMap, NavigableMap<C, Set<R>> otherMap) {
        JoinMapImpl mapThis = new JoinMapImpl();
        JoinMapImpl mapOther = new JoinMapImpl();
        Comparator comparator = thisMap.comparator();
        Iterator thisIterator = thisMap.keySet().iterator();
        Iterator otherIterator = otherMap.keySet().iterator();
        Object thisValue = thisIterator.next();
        Object otherValue = otherIterator.next();
        while (true) {
            Set thisSet;
            int compare;
            if ((compare = comparator.compare(thisValue, otherValue)) < 0) {
                thisSet = (Set)thisMap.get(thisValue);
                thisSet.clear();
                thisIterator.remove();
                if (!thisIterator.hasNext()) break;
                thisValue = thisIterator.next();
                continue;
            }
            if (compare > 0) {
                Set otherSet = (Set)otherMap.get(otherValue);
                otherSet.clear();
                otherIterator.remove();
                if (!otherIterator.hasNext()) break;
                otherValue = otherIterator.next();
                continue;
            }
            thisSet = (Set)thisMap.get(thisValue);
            Set otherSet = (Set)otherMap.get(otherValue);
            for (Object row : thisSet) {
                mapThis.put(row, otherSet);
            }
            for (Object row : otherSet) {
                mapOther.put(row, thisSet);
            }
            if (!thisIterator.hasNext() || !otherIterator.hasNext()) break;
            thisValue = thisIterator.next();
            otherValue = otherIterator.next();
        }
        if (thisIterator.hasNext()) {
            while (thisIterator.hasNext()) {
                thisValue = thisIterator.next();
                Set thisSet = (Set)thisMap.get(thisValue);
                thisSet.clear();
            }
        }
        if (otherIterator.hasNext()) {
            while (otherIterator.hasNext()) {
                otherValue = otherIterator.next();
                Set otherSet = (Set)otherMap.get(otherValue);
                otherSet.clear();
            }
        }
        return new JoinMap[]{mapThis, mapOther};
    }

    public NavigableSet<C> getColumnValues(String column) {
        return this.indexes.get(column).navigableKeySet();
    }

    public boolean hasData() {
        return this.all != null && !this.all.isEmpty();
    }

    public void updateHints(List<TableContext<R, C>> tableRanges) {
        for (TableContext tableContext : tableRanges) {
            if (this.table.equals(tableContext.getTable())) continue;
            for (String column : this.indexes.keySet()) {
                SortedMap map = this.indexes.get(column);
                if (map.isEmpty()) continue;
                tableContext.narrow(this.table, column, map.firstKey(), map.lastKey());
            }
        }
    }

    public void narrow(Table fromTable, String column, C lower, C upper) {
        for (ColumnCondition<R, C> tc : this.table.getAndConditions()) {
            if (!(tc instanceof JoinCondition)) continue;
            JoinCondition jc = (JoinCondition)tc;
            Range<C> range = this.columnRanges.get(column);
            if (range == null) {
                this.columnRanges.put(column, jc.narrow(this.selector, range, fromTable, column, lower, upper));
                continue;
            }
            jc.narrow(this.selector, range, fromTable, column, lower, upper);
        }
    }

    public Map<String, Range<C>> getColumnRanges() {
        return this.columnRanges;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableContext other = (TableContext)obj;
        return Objects.equals(this.table, other.table);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.table);
        return hash;
    }

    public String toString() {
        return "TableContext{table=" + this.table + '}';
    }

    public FastSet<R> getAll() {
        return this.all;
    }

    public Map<String, NavigableMap<C, Set<R>>> getIndexes() {
        return this.indexes;
    }

    public ArrayMap<Table<R, C>, TableContext<R, C>> getOthers() {
        return this.others;
    }

    public Engine<R, C> getSelector() {
        return this.selector;
    }

    private void removeAll() {
        this.all.clear();
        for (NavigableMap<C, Set<R>> map : this.indexes.values()) {
            map.clear();
        }
    }
}

