/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.Comparator;
import org.vesalainen.parsers.sql.ColumnCondition;
import org.vesalainen.parsers.sql.ColumnMetadata;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.Relation;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TableContext;
import org.vesalainen.parsers.sql.TableMetadata;
import org.vesalainen.parsers.sql.ValueComparisonCondition;

public class TableContextComparator<R, C>
implements Comparator<TableContext<R, C>> {
    private Engine engine;

    public TableContextComparator(Engine selector) {
        this.engine = selector;
    }

    @Override
    public int compare(TableContext<R, C> o1, TableContext<R, C> o2) {
        return this.estimateRows(o1) - this.estimateRows(o2);
    }

    private int estimateRows(TableContext<R, C> tc) {
        int estimate = Integer.MAX_VALUE;
        Table table = tc.getTable();
        TableMetadata tableMetadata = this.engine.getTableMetadata(table.getName());
        if (tableMetadata != null) {
            estimate = (int)tableMetadata.getCount();
            for (ColumnCondition columnCondition : table.getAndConditions()) {
                ColumnMetadata columnMetadata;
                ValueComparisonCondition cc;
                if (!(columnCondition instanceof ValueComparisonCondition) || !Relation.EQ.equals((Object)(cc = (ValueComparisonCondition)columnCondition).getRelation()) || (columnMetadata = tableMetadata.getColumnMetadata(cc.getColumn())) == null) continue;
                estimate = Math.min(estimate, (int)columnMetadata.getCount());
            }
        }
        return estimate;
    }
}

