/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.vesalainen.parsers.sql.AbstractFunction;
import org.vesalainen.parsers.sql.ColumnReference;

public class ToDateFunction
extends AbstractFunction {
    private SimpleDateFormat format;

    public ToDateFunction(ColumnReference inner, String ... format) {
        super(inner);
        switch (format.length) {
            case 0: {
                break;
            }
            case 1: {
                this.format = new SimpleDateFormat(format[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong number of arguments");
            }
        }
    }

    @Override
    public Object function(Object value) {
        if (value != null) {
            try {
                return this.format.parse(value.toString());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return null;
    }
}

