/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import org.vesalainen.parsers.sql.AbstractFunction;
import org.vesalainen.parsers.sql.ColumnReference;

public class ToStringFunction
extends AbstractFunction {
    private String format;

    public ToStringFunction(ColumnReference inner, String ... format) {
        super(inner);
        switch (format.length) {
            case 0: {
                break;
            }
            case 1: {
                this.format = format[0];
            }
            default: {
                throw new IllegalArgumentException("wrong number of arguments");
            }
        }
    }

    @Override
    public Object function(Object value) {
        if (value != null) {
            if (this.format != null) {
                return String.format(this.format, value);
            }
            return value.toString();
        }
        return null;
    }
}

