/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.vesalainen.parsers.sql.Condition;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.ErrorReporter;
import org.vesalainen.parsers.sql.FetchResult;
import org.vesalainen.parsers.sql.Metadata;
import org.vesalainen.parsers.sql.Placeholder;
import org.vesalainen.parsers.sql.SetClause;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.WhereStatement;

public class UpdateStatement<R, C>
extends WhereStatement<R, C> {
    private List<SetClause<R, C>> setClauseList;

    public UpdateStatement(Engine<R, C> engine, LinkedHashMap<String, Placeholder<R, C>> placeholderMap, Table<R, C> table, List<SetClause<R, C>> setClauseList) {
        super(engine, placeholderMap, table);
        this.setClauseList = setClauseList;
    }

    public UpdateStatement(Engine<R, C> engine, LinkedHashMap<String, Placeholder<R, C>> placeholderMap, Table<R, C> table, List<SetClause<R, C>> setClauseList, Condition<R, C> condition) {
        super(engine, placeholderMap, table, condition);
        this.setClauseList = setClauseList;
    }

    @Override
    public FetchResult<R, C> execute() {
        Collection rows = this.getTarget();
        for (Object row : rows) {
            for (SetClause<R, C> sc : this.setClauseList) {
                this.engine.set(row, sc.getColumn(), sc.getLiteral().getValue());
            }
        }
        this.engine.update(rows);
        return null;
    }

    @Override
    public void check(Metadata metadata, ErrorReporter reporter) {
    }
}

