/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.vesalainen.parsers.sql.ColumnReference;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.OrderedFetchResult;
import org.vesalainen.parsers.sql.SelectStatement;
import org.vesalainen.parsers.sql.SortSpecification;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.Updateable;
import org.vesalainen.parsers.sql.util.ArrayMap;

public class UpdateableFetchResult<R, C>
extends OrderedFetchResult<R, C> {
    protected List<Updateable<R, C>[]> updateable;
    protected Set<R> updated = new HashSet<R>();
    protected Set<R> deleted = new HashSet<R>();

    public UpdateableFetchResult(Engine<R, C> engine, SelectStatement<R, C> select) {
        super(engine, select);
        this.updateable = new ArrayList<Updateable<R, C>[]>();
    }

    @Override
    public void addRow(ArrayMap<Table<R, C>, R> rowCandidate) {
        Updateable[] row = new Updateable[this.length];
        this.updateable.add(row);
        int index = 0;
        for (ColumnReference cf : this.columnReferences) {
            Updateable<R, C> col = this.engine.getUpdateable(rowCandidate.get(cf.getTable()), cf.getColumn(), cf.getValue(this.engine, rowCandidate));
            if (col != null && col.getValue() != null) {
                this.columnLength[index] = Math.max(this.columnLength[index], col.getValue().toString().length());
            }
            row[index++] = col;
        }
    }

    @Override
    public Iterator<C[]> iterator() {
        if (!this.sorted && this.sortSpecification != null) {
            ArrayComparator comparator = new ArrayComparator(this.engine.getComparator(), this.columnReferences, this.sortSpecification);
            Collections.sort(this.updateable, comparator);
            this.sorted = true;
        }
        return new DataIterator();
    }

    @Override
    public int getRowCount() {
        return this.updateable.size();
    }

    @Override
    public C getValueAt(int row, int column) {
        return this.updateable.get(row)[column].getValue();
    }

    @Override
    public C getValueAt(int row, String column) {
        Integer col = (Integer)this.columnMap.get(column);
        if (col == null) {
            throw new IllegalArgumentException(column + " not found");
        }
        return this.updateable.get(row)[col].getValue();
    }

    public void setValueAt(C value, int row, int column) {
        Updateable<R, C> u = this.updateable.get(row)[column];
        R updatedRow = u.setValue(value);
        if (updatedRow != null) {
            this.updated.add(updatedRow);
        }
    }

    public void deleteRow(int row) {
        for (Updateable<R, C> u : this.updateable.get(row)) {
            R r = u.getRow();
            this.deleted.add(r);
            this.updated.remove(r);
        }
        this.updateable.remove(row);
    }

    public void insertRow() {
    }

    public void rollback() {
        this.engine.rollbackTransaction();
    }

    public void updateAndCommit() {
        this.engine.delete(this.deleted);
        this.engine.update(this.updated);
        this.engine.commitTransaction();
    }

    private class ArrayComparator
    implements Comparator<Updateable<R, C>[]> {
        private Comparator<C> comp;
        private int[] cols;
        private int[] signs;

        public ArrayComparator(Comparator<C> comp, List<ColumnReference<R, C>> columnReferences, List<SortSpecification> sortSpecification) {
            this.comp = comp;
            this.cols = new int[sortSpecification.size()];
            this.signs = new int[sortSpecification.size()];
            int index = 0;
            for (SortSpecification ss : sortSpecification) {
                this.cols[index] = columnReferences.indexOf(ss.getRv());
                this.signs[index] = ss.isAscending() ? 1 : -1;
                ++index;
            }
        }

        @Override
        public int compare(Updateable<R, C>[] o1, Updateable<R, C>[] o2) {
            int cmp = 0;
            for (int ii = 0; ii < this.cols.length && (cmp = this.signs[ii] * this.comp.compare(o1[this.cols[ii]].getValue(), o2[this.cols[ii]].getValue())) == 0; ++ii) {
            }
            return cmp;
        }
    }

    public class DataIterator
    implements Iterator<C[]> {
        private Iterator<Updateable<R, C>[]> iterator;
        private C[] next;

        public DataIterator() {
            this.next = new Object[UpdateableFetchResult.this.header.length];
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public C[] next() {
            Updateable<R, C>[] nextUpd = this.iterator.next();
            for (int ii = 0; ii < this.next.length; ++ii) {
                this.next[ii] = nextUpd[ii].getValue();
            }
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

