/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.vesalainen.parsers.sql.ColumnCondition;
import org.vesalainen.parsers.sql.Condition;
import org.vesalainen.parsers.sql.ConditionVisitor;
import org.vesalainen.parsers.sql.Engine;
import org.vesalainen.parsers.sql.Placeholder;
import org.vesalainen.parsers.sql.Statement;
import org.vesalainen.parsers.sql.Table;
import org.vesalainen.parsers.sql.TruthValue;
import org.vesalainen.parsers.sql.util.ArrayMap;

public abstract class WhereStatement<R, C>
extends Statement<R, C>
implements ConditionVisitor {
    protected Table<R, C> table;
    protected Condition<R, C> condition;

    public WhereStatement(Engine<R, C> engine, LinkedHashMap<String, Placeholder<R, C>> placeholderMap, Table<R, C> table, Condition<R, C> condition) {
        super(engine, placeholderMap);
        this.table = table;
        this.condition = condition;
        this.walk();
    }

    public WhereStatement(Engine<R, C> engine, LinkedHashMap<String, Placeholder<R, C>> placeholderMap, Table<R, C> table) {
        super(engine, placeholderMap);
        this.table = table;
    }

    private void walk() {
        this.condition.walk(this, true);
    }

    protected Collection<R> getTarget() {
        Collection<R> rows = this.engine.fetch(this.table);
        ArrayMap<Table, R> rowCandidate = new ArrayMap<Table, R>(this.table);
        int index = rowCandidate.getIndexOf(this.table);
        Iterator<R> iterator = rows.iterator();
        while (iterator.hasNext()) {
            R row = iterator.next();
            rowCandidate.put(index, row);
            if (this.condition == null || this.condition.matches(this.engine, rowCandidate) == TruthValue.TRUE) continue;
            iterator.remove();
        }
        return rows;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public void visit(Condition condition, boolean andPath) {
        if (condition instanceof ColumnCondition) {
            ColumnCondition cc = (ColumnCondition)condition;
            this.table.associateCondition(cc, andPath);
        }
    }
}

